/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/js/paypalButtonUtils.js":
/*!*******************************************!*\
  !*** ./resources/js/paypalButtonUtils.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ajaxCallToOrder: () => (/* binding */ ajaxCallToOrder)
/* harmony export */ });
var ajaxCallToOrder = function ajaxCallToOrder(ajaxUrl) {
  var button = document.getElementById('mollie-PayPal-button');
  if (!button) {
    return;
  }
  var preventSpam = false;
  var nonce = button.children[0].value;
  button.addEventListener('click', function (evt) {
    evt.preventDefault();
    if (!button) {
      return;
    }
    button.disabled = true;
    button.classList.add("buttonDisabled");
    jQuery.ajax({
      url: ajaxUrl,
      method: 'POST',
      data: {
        action: 'mollie_paypal_create_order_cart',
        'mollie-payments-for-woocommerce_issuer_paypal_button': 'paypal',
        nonce: nonce
      },
      success: function success(response) {
        var result = response.data;
        if (response.success === true) {
          window.location.href = result['redirect'];
        } else {
          console.log(response.data);
        }
      },
      error: function error(jqXHR, textStatus, errorThrown) {
        button.disabled = false;
        button.classList.remove("buttonDisabled");
        console.warn(textStatus, errorThrown);
      }
    });
    preventSpam = true;
    if (preventSpam) {
      setTimeout(function () {
        button.disabled = false;
        button.classList.remove("buttonDisabled");
        preventSpam = false;
      }, 3000);
    }
  });
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!******************************************!*\
  !*** ./resources/js/paypalButtonCart.js ***!
  \******************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _paypalButtonUtils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./paypalButtonUtils */ "./resources/js/paypalButtonUtils.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

(function (_ref) {
  var _ = _ref._,
    molliepaypalButtonCart = _ref.molliepaypalButtonCart,
    jQuery = _ref.jQuery;
  if (_.isEmpty(molliepaypalButtonCart)) {
    return;
  }
  var minFee = molliepaypalButtonCart.product.minFee,
    ajaxUrl = molliepaypalButtonCart.ajaxUrl;
  if (!ajaxUrl) {
    return;
  }
  var maybeShowButton = function maybeShowButton(underRange) {
    if (underRange) {
      hideButton();
    }
  };
  var hideButton = function hideButton() {
    var payPalButton = document.getElementById('mollie-PayPal-button');
    if (payPalButton.parentNode !== null) {
      payPalButton.parentNode.removeChild(payPalButton);
    }
  };
  var extractValue = function extractValue(path) {
    return parseFloat(path.textContent).toFixed(2);
  };
  var calculateTaxes = function calculateTaxes() {
    var taxesPath = document.getElementsByClassName('tax-rate');
    if (taxesPath.length === 0) {
      return 0;
    }
    var total = 0.00;
    var _iterator = _createForOfIteratorHelper(taxesPath),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var tax = _step.value;
        var taxPath = tax.getElementsByClassName('woocommerce-Price-amount')[0];
        var workingNode = taxPath.cloneNode(true);
        var currency = workingNode.lastChild;
        workingNode.removeChild(currency);
        total += parseFloat(extractValue(workingNode));
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return total;
  };
  var calculateTotal = function calculateTotal() {
    var subtotalPath = document.getElementsByClassName('cart-subtotal')[0].getElementsByClassName('woocommerce-Price-amount')[0].childNodes[0];
    var workingNode = subtotalPath.cloneNode(true);
    var currency = workingNode.getElementsByClassName('woocommerce-Price-currencySymbol')[0];
    workingNode.removeChild(currency);
    var total = parseFloat(extractValue(workingNode));
    total += calculateTaxes();
    return total;
  };
  var underRange = function underRange() {
    var updatedPrice = calculateTotal();
    return minFee > updatedPrice;
  };
  jQuery(document.body).on('updated_cart_totals', function (event) {
    var payPalButton = document.getElementById('mollie-PayPal-button');
    if (payPalButton == null || payPalButton.parentNode == null) {
      return;
    }
    maybeShowButton(underRange());
    (0,_paypalButtonUtils__WEBPACK_IMPORTED_MODULE_0__.ajaxCallToOrder)(ajaxUrl);
  });
  setTimeout(function () {
    var payPalButton = document.getElementById('mollie-PayPal-button');
    if (payPalButton == null || payPalButton.parentNode == null) {
      return;
    }
    maybeShowButton(underRange());
    (0,_paypalButtonUtils__WEBPACK_IMPORTED_MODULE_0__.ajaxCallToOrder)(ajaxUrl);
  }, 500);
})(window);
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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