/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/js/paypalButtonUtils.js":
/*!*******************************************!*\
  !*** ./resources/js/paypalButtonUtils.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ajaxCallToOrder: () => (/* binding */ ajaxCallToOrder)
/* harmony export */ });
var ajaxCallToOrder = function ajaxCallToOrder(ajaxUrl) {
  var button = document.getElementById('mollie-PayPal-button');
  if (!button) {
    return;
  }
  var preventSpam = false;
  var nonce = button.children[0].value;
  button.addEventListener('click', function (evt) {
    evt.preventDefault();
    if (!button) {
      return;
    }
    button.disabled = true;
    button.classList.add("buttonDisabled");
    jQuery.ajax({
      url: ajaxUrl,
      method: 'POST',
      data: {
        action: 'mollie_paypal_create_order_cart',
        'mollie-payments-for-woocommerce_issuer_paypal_button': 'paypal',
        nonce: nonce
      },
      success: function success(response) {
        var result = response.data;
        if (response.success === true) {
          window.location.href = result['redirect'];
        } else {
          console.log(response.data);
        }
      },
      error: function error(jqXHR, textStatus, errorThrown) {
        button.disabled = false;
        button.classList.remove("buttonDisabled");
        console.warn(textStatus, errorThrown);
      }
    });
    preventSpam = true;
    if (preventSpam) {
      setTimeout(function () {
        button.disabled = false;
        button.classList.remove("buttonDisabled");
        preventSpam = false;
      }, 3000);
    }
  });
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!****************************************************!*\
  !*** ./resources/js/paypalButtonBlockComponent.js ***!
  \****************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _paypalButtonUtils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./paypalButtonUtils */ "./resources/js/paypalButtonUtils.js");

(function (_ref) {
  var molliepaypalButtonCart = _ref.molliepaypalButtonCart;
  if (molliepaypalButtonCart.length === 0) {
    return;
  }
  var registerPlugin = wp.plugins.registerPlugin;
  var ExperimentalOrderMeta = wc.blocksCheckout.ExperimentalOrderMeta;
  var minFee = molliepaypalButtonCart.minFee,
    ajaxUrl = molliepaypalButtonCart.ajaxUrl,
    buttonMarkup = molliepaypalButtonCart.buttonMarkup;
  var PayPalButtonComponent = function PayPalButtonComponent(_ref2) {
    var cart = _ref2.cart,
      extensions = _ref2.extensions;
    var cartTotal = cart.cartTotals.total_price / Math.pow(10, cart.cartTotals.currency_minor_unit);
    var amountOverRangeSetting = cartTotal > minFee;
    var cartNeedsShipping = cart.cartNeedsShipping;
    return amountOverRangeSetting && !cartNeedsShipping ? /*#__PURE__*/React.createElement("div", {
      dangerouslySetInnerHTML: {
        __html: buttonMarkup
      }
    }) : null;
  };
  var MolliePayPalButtonCart = function MolliePayPalButtonCart() {
    return /*#__PURE__*/React.createElement(ExperimentalOrderMeta, null, /*#__PURE__*/React.createElement(PayPalButtonComponent, null));
  };
  registerPlugin('mollie-paypal-block-button', {
    render: function render() {
      return /*#__PURE__*/React.createElement(MolliePayPalButtonCart, null);
    },
    scope: 'woocommerce-checkout'
  });
  setTimeout(function () {
    var payPalButton = document.getElementById('mollie-PayPal-button');
    if (payPalButton == null || payPalButton.parentNode == null) {
      return;
    }
    (0,_paypalButtonUtils__WEBPACK_IMPORTED_MODULE_0__.ajaxCallToOrder)(ajaxUrl);
  }, 3000);
})(window);
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGF5cGFsQnV0dG9uQmxvY2tDb21wb25lbnQubWluLmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7O0FBQU8sSUFBTUEsZUFBZSxHQUFHLFNBQWxCQSxlQUFlQSxDQUFJQyxPQUFPLEVBQUs7RUFDeEMsSUFBSUMsTUFBTSxHQUFHQyxRQUFRLENBQUNDLGNBQWMsQ0FBQyxzQkFBc0IsQ0FBQztFQUM1RCxJQUFHLENBQUNGLE1BQU0sRUFBQztJQUNQO0VBQ0o7RUFFQSxJQUFJRyxXQUFXLEdBQUcsS0FBSztFQUN2QixJQUFNQyxLQUFLLEdBQUdKLE1BQU0sQ0FBQ0ssUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDQyxLQUFLO0VBQ3RDTixNQUFNLENBQUNPLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxVQUFDQyxHQUFHLEVBQUs7SUFDdENBLEdBQUcsQ0FBQ0MsY0FBYyxDQUFDLENBQUM7SUFDcEIsSUFBRyxDQUFDVCxNQUFNLEVBQUM7TUFDUDtJQUNKO0lBQ0FBLE1BQU0sQ0FBQ1UsUUFBUSxHQUFHLElBQUk7SUFDdEJWLE1BQU0sQ0FBQ1csU0FBUyxDQUFDQyxHQUFHLENBQUMsZ0JBQWdCLENBQUM7SUFDdENDLE1BQU0sQ0FBQ0MsSUFBSSxDQUFDO01BQ1JDLEdBQUcsRUFBRWhCLE9BQU87TUFDWmlCLE1BQU0sRUFBRSxNQUFNO01BQ2RDLElBQUksRUFBRTtRQUNGQyxNQUFNLEVBQUUsaUNBQWlDO1FBQ3pDLHNEQUFzRCxFQUFFLFFBQVE7UUFDaEVkLEtBQUssRUFBRUE7TUFDWCxDQUFDO01BQ0RlLE9BQU8sRUFBRSxTQUFBQSxRQUFDQyxRQUFRLEVBQUs7UUFDbkIsSUFBSUMsTUFBTSxHQUFHRCxRQUFRLENBQUNILElBQUk7UUFDMUIsSUFBSUcsUUFBUSxDQUFDRCxPQUFPLEtBQUssSUFBSSxFQUFFO1VBQzNCRyxNQUFNLENBQUNDLFFBQVEsQ0FBQ0MsSUFBSSxHQUFHSCxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQzdDLENBQUMsTUFBTTtVQUNISSxPQUFPLENBQUNDLEdBQUcsQ0FBQ04sUUFBUSxDQUFDSCxJQUFJLENBQUM7UUFDOUI7TUFDSixDQUFDO01BQ0RVLEtBQUssRUFBRSxTQUFBQSxNQUFDQyxLQUFLLEVBQUVDLFVBQVUsRUFBRUMsV0FBVyxFQUFLO1FBQ3ZDOUIsTUFBTSxDQUFDVSxRQUFRLEdBQUcsS0FBSztRQUN2QlYsTUFBTSxDQUFDVyxTQUFTLENBQUNvQixNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDekNOLE9BQU8sQ0FBQ08sSUFBSSxDQUFDSCxVQUFVLEVBQUVDLFdBQVcsQ0FBQztNQUN6QztJQUNKLENBQUMsQ0FBQztJQUNGM0IsV0FBVyxHQUFHLElBQUk7SUFDbEIsSUFBR0EsV0FBVyxFQUFDO01BQ1g4QixVQUFVLENBQUMsWUFBVztRQUNsQmpDLE1BQU0sQ0FBQ1UsUUFBUSxHQUFHLEtBQUs7UUFDdkJWLE1BQU0sQ0FBQ1csU0FBUyxDQUFDb0IsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ3pDNUIsV0FBVyxHQUFHLEtBQUs7TUFDdkIsQ0FBQyxFQUFFLElBQUksQ0FBQztJQUNaO0VBQ0osQ0FBQyxDQUFDO0FBQ04sQ0FBQzs7Ozs7O1VDOUNEO1VBQ0E7O1VBRUE7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7O1VBRUE7VUFDQTs7VUFFQTtVQUNBO1VBQ0E7Ozs7O1dDdEJBO1dBQ0E7V0FDQTtXQUNBO1dBQ0EseUNBQXlDLHdDQUF3QztXQUNqRjtXQUNBO1dBQ0E7Ozs7O1dDUEE7Ozs7O1dDQUE7V0FDQTtXQUNBO1dBQ0EsdURBQXVELGlCQUFpQjtXQUN4RTtXQUNBLGdEQUFnRCxhQUFhO1dBQzdEOzs7Ozs7Ozs7Ozs7QUNOb0Q7QUFFcEQsQ0FDSSxVQUFBK0IsSUFBQSxFQUNBO0VBQUEsSUFEYUMsc0JBQXNCLEdBQUFELElBQUEsQ0FBdEJDLHNCQUFzQjtFQUUvQixJQUFJQSxzQkFBc0IsQ0FBQ0MsTUFBTSxLQUFLLENBQUMsRUFBRztJQUN0QztFQUNKO0VBRUEsSUFBUUMsY0FBYyxHQUFLQyxFQUFFLENBQUNDLE9BQU8sQ0FBN0JGLGNBQWM7RUFDdEIsSUFBUUcscUJBQXFCLEdBQUtDLEVBQUUsQ0FBQ0MsY0FBYyxDQUEzQ0YscUJBQXFCO0VBQzdCLElBQVFHLE1BQU0sR0FBNEJSLHNCQUFzQixDQUF4RFEsTUFBTTtJQUFFNUMsT0FBTyxHQUFtQm9DLHNCQUFzQixDQUFoRHBDLE9BQU87SUFBRTZDLFlBQVksR0FBS1Qsc0JBQXNCLENBQXZDUyxZQUFZO0VBQ3JDLElBQU1DLHFCQUFxQixHQUFHLFNBQXhCQSxxQkFBcUJBLENBQUFDLEtBQUEsRUFBK0I7SUFBQSxJQUF4QkMsSUFBSSxHQUFBRCxLQUFBLENBQUpDLElBQUk7TUFBRUMsVUFBVSxHQUFBRixLQUFBLENBQVZFLFVBQVU7SUFDOUMsSUFBSUMsU0FBUyxHQUFHRixJQUFJLENBQUNHLFVBQVUsQ0FBQ0MsV0FBVyxHQUFDQyxJQUFJLENBQUNDLEdBQUcsQ0FBQyxFQUFFLEVBQUVOLElBQUksQ0FBQ0csVUFBVSxDQUFDSSxtQkFBbUIsQ0FBQztJQUM3RixJQUFNQyxzQkFBc0IsR0FBR04sU0FBUyxHQUFHTixNQUFNO0lBQ2pELElBQU1hLGlCQUFpQixHQUFHVCxJQUFJLENBQUNTLGlCQUFpQjtJQUNoRCxPQUFPRCxzQkFBc0IsSUFBSSxDQUFDQyxpQkFBaUIsZ0JBQUdDLEtBQUEsQ0FBQUMsYUFBQTtNQUFLQyx1QkFBdUIsRUFBRztRQUFDQyxNQUFNLEVBQUVoQjtNQUFZO0lBQUcsQ0FBQyxDQUFDLEdBQUUsSUFBSTtFQUN6SCxDQUFDO0VBQ0QsSUFBTWlCLHNCQUFzQixHQUFHLFNBQXpCQSxzQkFBc0JBLENBQUEsRUFBUztJQUNqQyxvQkFBUUosS0FBQSxDQUFBQyxhQUFBLENBQUNsQixxQkFBcUIscUJBQ3RCaUIsS0FBQSxDQUFBQyxhQUFBLENBQUNiLHFCQUFxQixNQUFFLENBQ0wsQ0FBQztFQUNoQyxDQUFDO0VBRURSLGNBQWMsQ0FBRSw0QkFBNEIsRUFBRTtJQUMxQ3lCLE1BQU0sRUFBRSxTQUFBQSxPQUFBLEVBQU07TUFDVixvQkFBT0wsS0FBQSxDQUFBQyxhQUFBLENBQUNHLHNCQUFzQixNQUFFLENBQUM7SUFDckMsQ0FBQztJQUNERSxLQUFLLEVBQUU7RUFDWCxDQUFFLENBQUM7RUFFSDlCLFVBQVUsQ0FBQyxZQUFVO0lBQ2pCLElBQUkrQixZQUFZLEdBQUcvRCxRQUFRLENBQUNDLGNBQWMsQ0FBQyxzQkFBc0IsQ0FBQztJQUNsRSxJQUFHOEQsWUFBWSxJQUFJLElBQUksSUFBSUEsWUFBWSxDQUFDQyxVQUFVLElBQUksSUFBSSxFQUFDO01BQ3ZEO0lBQ0o7SUFDQW5FLG1FQUFlLENBQUNDLE9BQU8sQ0FBQztFQUM1QixDQUFDLEVBQUMsSUFBSSxDQUFDO0FBQ1gsQ0FBQyxFQUdEdUIsTUFDSixDQUFDLEMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tb2xsaWUtcGF5bWVudHMtZm9yLXdvb2NvbW1lcmNlLy4vcmVzb3VyY2VzL2pzL3BheXBhbEJ1dHRvblV0aWxzLmpzIiwid2VicGFjazovL21vbGxpZS1wYXltZW50cy1mb3Itd29vY29tbWVyY2Uvd2VicGFjay9ib290c3RyYXAiLCJ3ZWJwYWNrOi8vbW9sbGllLXBheW1lbnRzLWZvci13b29jb21tZXJjZS93ZWJwYWNrL3J1bnRpbWUvZGVmaW5lIHByb3BlcnR5IGdldHRlcnMiLCJ3ZWJwYWNrOi8vbW9sbGllLXBheW1lbnRzLWZvci13b29jb21tZXJjZS93ZWJwYWNrL3J1bnRpbWUvaGFzT3duUHJvcGVydHkgc2hvcnRoYW5kIiwid2VicGFjazovL21vbGxpZS1wYXltZW50cy1mb3Itd29vY29tbWVyY2Uvd2VicGFjay9ydW50aW1lL21ha2UgbmFtZXNwYWNlIG9iamVjdCIsIndlYnBhY2s6Ly9tb2xsaWUtcGF5bWVudHMtZm9yLXdvb2NvbW1lcmNlLy4vcmVzb3VyY2VzL2pzL3BheXBhbEJ1dHRvbkJsb2NrQ29tcG9uZW50LmpzIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBjb25zdCBhamF4Q2FsbFRvT3JkZXIgPSAoYWpheFVybCkgPT4ge1xuICAgIGxldCBidXR0b24gPSBkb2N1bWVudC5nZXRFbGVtZW50QnlJZCgnbW9sbGllLVBheVBhbC1idXR0b24nKVxuICAgIGlmKCFidXR0b24pe1xuICAgICAgICByZXR1cm5cbiAgICB9XG5cbiAgICBsZXQgcHJldmVudFNwYW0gPSBmYWxzZVxuICAgIGNvbnN0IG5vbmNlID0gYnV0dG9uLmNoaWxkcmVuWzBdLnZhbHVlXG4gICAgYnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgKGV2dCkgPT4ge1xuICAgICAgICBldnQucHJldmVudERlZmF1bHQoKVxuICAgICAgICBpZighYnV0dG9uKXtcbiAgICAgICAgICAgIHJldHVyblxuICAgICAgICB9XG4gICAgICAgIGJ1dHRvbi5kaXNhYmxlZCA9IHRydWU7XG4gICAgICAgIGJ1dHRvbi5jbGFzc0xpc3QuYWRkKFwiYnV0dG9uRGlzYWJsZWRcIik7XG4gICAgICAgIGpRdWVyeS5hamF4KHtcbiAgICAgICAgICAgIHVybDogYWpheFVybCxcbiAgICAgICAgICAgIG1ldGhvZDogJ1BPU1QnLFxuICAgICAgICAgICAgZGF0YToge1xuICAgICAgICAgICAgICAgIGFjdGlvbjogJ21vbGxpZV9wYXlwYWxfY3JlYXRlX29yZGVyX2NhcnQnLFxuICAgICAgICAgICAgICAgICdtb2xsaWUtcGF5bWVudHMtZm9yLXdvb2NvbW1lcmNlX2lzc3Vlcl9wYXlwYWxfYnV0dG9uJzogJ3BheXBhbCcsXG4gICAgICAgICAgICAgICAgbm9uY2U6IG5vbmNlLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHN1Y2Nlc3M6IChyZXNwb25zZSkgPT4ge1xuICAgICAgICAgICAgICAgIGxldCByZXN1bHQgPSByZXNwb25zZS5kYXRhXG4gICAgICAgICAgICAgICAgaWYgKHJlc3BvbnNlLnN1Y2Nlc3MgPT09IHRydWUpIHtcbiAgICAgICAgICAgICAgICAgICAgd2luZG93LmxvY2F0aW9uLmhyZWYgPSByZXN1bHRbJ3JlZGlyZWN0J11cbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICBjb25zb2xlLmxvZyhyZXNwb25zZS5kYXRhKVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBlcnJvcjogKGpxWEhSLCB0ZXh0U3RhdHVzLCBlcnJvclRocm93bikgPT4ge1xuICAgICAgICAgICAgICAgIGJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlO1xuICAgICAgICAgICAgICAgIGJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKFwiYnV0dG9uRGlzYWJsZWRcIik7XG4gICAgICAgICAgICAgICAgY29uc29sZS53YXJuKHRleHRTdGF0dXMsIGVycm9yVGhyb3duKVxuICAgICAgICAgICAgfSxcbiAgICAgICAgfSlcbiAgICAgICAgcHJldmVudFNwYW0gPSB0cnVlXG4gICAgICAgIGlmKHByZXZlbnRTcGFtKXtcbiAgICAgICAgICAgIHNldFRpbWVvdXQoZnVuY3Rpb24oKSB7XG4gICAgICAgICAgICAgICAgYnV0dG9uLmRpc2FibGVkID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgYnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoXCJidXR0b25EaXNhYmxlZFwiKTtcbiAgICAgICAgICAgICAgICBwcmV2ZW50U3BhbSA9IGZhbHNlXG4gICAgICAgICAgICB9LCAzMDAwKTtcbiAgICAgICAgfVxuICAgIH0pXG59XG4iLCIvLyBUaGUgbW9kdWxlIGNhY2hlXG52YXIgX193ZWJwYWNrX21vZHVsZV9jYWNoZV9fID0ge307XG5cbi8vIFRoZSByZXF1aXJlIGZ1bmN0aW9uXG5mdW5jdGlvbiBfX3dlYnBhY2tfcmVxdWlyZV9fKG1vZHVsZUlkKSB7XG5cdC8vIENoZWNrIGlmIG1vZHVsZSBpcyBpbiBjYWNoZVxuXHR2YXIgY2FjaGVkTW9kdWxlID0gX193ZWJwYWNrX21vZHVsZV9jYWNoZV9fW21vZHVsZUlkXTtcblx0aWYgKGNhY2hlZE1vZHVsZSAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0cmV0dXJuIGNhY2hlZE1vZHVsZS5leHBvcnRzO1xuXHR9XG5cdC8vIENyZWF0ZSBhIG5ldyBtb2R1bGUgKGFuZCBwdXQgaXQgaW50byB0aGUgY2FjaGUpXG5cdHZhciBtb2R1bGUgPSBfX3dlYnBhY2tfbW9kdWxlX2NhY2hlX19bbW9kdWxlSWRdID0ge1xuXHRcdC8vIG5vIG1vZHVsZS5pZCBuZWVkZWRcblx0XHQvLyBubyBtb2R1bGUubG9hZGVkIG5lZWRlZFxuXHRcdGV4cG9ydHM6IHt9XG5cdH07XG5cblx0Ly8gRXhlY3V0ZSB0aGUgbW9kdWxlIGZ1bmN0aW9uXG5cdF9fd2VicGFja19tb2R1bGVzX19bbW9kdWxlSWRdKG1vZHVsZSwgbW9kdWxlLmV4cG9ydHMsIF9fd2VicGFja19yZXF1aXJlX18pO1xuXG5cdC8vIFJldHVybiB0aGUgZXhwb3J0cyBvZiB0aGUgbW9kdWxlXG5cdHJldHVybiBtb2R1bGUuZXhwb3J0cztcbn1cblxuIiwiLy8gZGVmaW5lIGdldHRlciBmdW5jdGlvbnMgZm9yIGhhcm1vbnkgZXhwb3J0c1xuX193ZWJwYWNrX3JlcXVpcmVfXy5kID0gKGV4cG9ydHMsIGRlZmluaXRpb24pID0+IHtcblx0Zm9yKHZhciBrZXkgaW4gZGVmaW5pdGlvbikge1xuXHRcdGlmKF9fd2VicGFja19yZXF1aXJlX18ubyhkZWZpbml0aW9uLCBrZXkpICYmICFfX3dlYnBhY2tfcmVxdWlyZV9fLm8oZXhwb3J0cywga2V5KSkge1xuXHRcdFx0T2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIGtleSwgeyBlbnVtZXJhYmxlOiB0cnVlLCBnZXQ6IGRlZmluaXRpb25ba2V5XSB9KTtcblx0XHR9XG5cdH1cbn07IiwiX193ZWJwYWNrX3JlcXVpcmVfXy5vID0gKG9iaiwgcHJvcCkgPT4gKE9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHkuY2FsbChvYmosIHByb3ApKSIsIi8vIGRlZmluZSBfX2VzTW9kdWxlIG9uIGV4cG9ydHNcbl9fd2VicGFja19yZXF1aXJlX18uciA9IChleHBvcnRzKSA9PiB7XG5cdGlmKHR5cGVvZiBTeW1ib2wgIT09ICd1bmRlZmluZWQnICYmIFN5bWJvbC50b1N0cmluZ1RhZykge1xuXHRcdE9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBTeW1ib2wudG9TdHJpbmdUYWcsIHsgdmFsdWU6ICdNb2R1bGUnIH0pO1xuXHR9XG5cdE9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCAnX19lc01vZHVsZScsIHsgdmFsdWU6IHRydWUgfSk7XG59OyIsImltcG9ydCB7YWpheENhbGxUb09yZGVyfSBmcm9tIFwiLi9wYXlwYWxCdXR0b25VdGlsc1wiO1xuXG4oXG4gICAgZnVuY3Rpb24gKHsgIG1vbGxpZXBheXBhbEJ1dHRvbkNhcnR9KVxuICAgIHtcbiAgICAgICAgaWYgKG1vbGxpZXBheXBhbEJ1dHRvbkNhcnQubGVuZ3RoID09PSAwICkge1xuICAgICAgICAgICAgcmV0dXJuXG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCB7IHJlZ2lzdGVyUGx1Z2luIH0gPSB3cC5wbHVnaW5zO1xuICAgICAgICBjb25zdCB7IEV4cGVyaW1lbnRhbE9yZGVyTWV0YSB9ID0gd2MuYmxvY2tzQ2hlY2tvdXQ7XG4gICAgICAgIGNvbnN0IHsgbWluRmVlLCBhamF4VXJsLCBidXR0b25NYXJrdXAgfSA9IG1vbGxpZXBheXBhbEJ1dHRvbkNhcnQ7XG4gICAgICAgIGNvbnN0IFBheVBhbEJ1dHRvbkNvbXBvbmVudCA9ICggeyBjYXJ0LCBleHRlbnNpb25zIH0gKSA9PiB7XG4gICAgICAgICAgICBsZXQgY2FydFRvdGFsID0gY2FydC5jYXJ0VG90YWxzLnRvdGFsX3ByaWNlL01hdGgucG93KDEwLCBjYXJ0LmNhcnRUb3RhbHMuY3VycmVuY3lfbWlub3JfdW5pdClcbiAgICAgICAgICAgIGNvbnN0IGFtb3VudE92ZXJSYW5nZVNldHRpbmcgPSBjYXJ0VG90YWwgPiBtaW5GZWU7XG4gICAgICAgICAgICBjb25zdCBjYXJ0TmVlZHNTaGlwcGluZyA9IGNhcnQuY2FydE5lZWRzU2hpcHBpbmdcbiAgICAgICAgICAgIHJldHVybiBhbW91bnRPdmVyUmFuZ2VTZXR0aW5nICYmICFjYXJ0TmVlZHNTaGlwcGluZyA/IDxkaXYgZGFuZ2Vyb3VzbHlTZXRJbm5lckhUTUw9eyB7X19odG1sOiBidXR0b25NYXJrdXB9IH0vPjogbnVsbFxuICAgICAgICB9XG4gICAgICAgIGNvbnN0IE1vbGxpZVBheVBhbEJ1dHRvbkNhcnQgPSAoKSA9PiB7XG4gICAgICAgICAgICByZXR1cm4gIDxFeHBlcmltZW50YWxPcmRlck1ldGE+XG4gICAgICAgICAgICAgICAgICAgIDxQYXlQYWxCdXR0b25Db21wb25lbnQgLz5cbiAgICAgICAgICAgICAgICA8L0V4cGVyaW1lbnRhbE9yZGVyTWV0YT5cbiAgICAgICAgfTtcblxuICAgICAgICByZWdpc3RlclBsdWdpbiggJ21vbGxpZS1wYXlwYWwtYmxvY2stYnV0dG9uJywge1xuICAgICAgICAgICAgcmVuZGVyOiAoKSA9PiB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIDxNb2xsaWVQYXlQYWxCdXR0b25DYXJ0IC8+O1xuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHNjb3BlOiAnd29vY29tbWVyY2UtY2hlY2tvdXQnXG4gICAgICAgIH0gKTtcblxuICAgICAgICBzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7XG4gICAgICAgICAgICBsZXQgcGF5UGFsQnV0dG9uID0gZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoJ21vbGxpZS1QYXlQYWwtYnV0dG9uJyk7XG4gICAgICAgICAgICBpZihwYXlQYWxCdXR0b24gPT0gbnVsbCB8fCBwYXlQYWxCdXR0b24ucGFyZW50Tm9kZSA9PSBudWxsKXtcbiAgICAgICAgICAgICAgICByZXR1cm5cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGFqYXhDYWxsVG9PcmRlcihhamF4VXJsKVxuICAgICAgICB9LDMwMDApO1xuICAgIH1cbilcbihcbiAgICB3aW5kb3dcbilcbiJdLCJuYW1lcyI6WyJhamF4Q2FsbFRvT3JkZXIiLCJhamF4VXJsIiwiYnV0dG9uIiwiZG9jdW1lbnQiLCJnZXRFbGVtZW50QnlJZCIsInByZXZlbnRTcGFtIiwibm9uY2UiLCJjaGlsZHJlbiIsInZhbHVlIiwiYWRkRXZlbnRMaXN0ZW5lciIsImV2dCIsInByZXZlbnREZWZhdWx0IiwiZGlzYWJsZWQiLCJjbGFzc0xpc3QiLCJhZGQiLCJqUXVlcnkiLCJhamF4IiwidXJsIiwibWV0aG9kIiwiZGF0YSIsImFjdGlvbiIsInN1Y2Nlc3MiLCJyZXNwb25zZSIsInJlc3VsdCIsIndpbmRvdyIsImxvY2F0aW9uIiwiaHJlZiIsImNvbnNvbGUiLCJsb2ciLCJlcnJvciIsImpxWEhSIiwidGV4dFN0YXR1cyIsImVycm9yVGhyb3duIiwicmVtb3ZlIiwid2FybiIsInNldFRpbWVvdXQiLCJfcmVmIiwibW9sbGllcGF5cGFsQnV0dG9uQ2FydCIsImxlbmd0aCIsInJlZ2lzdGVyUGx1Z2luIiwid3AiLCJwbHVnaW5zIiwiRXhwZXJpbWVudGFsT3JkZXJNZXRhIiwid2MiLCJibG9ja3NDaGVja291dCIsIm1pbkZlZSIsImJ1dHRvbk1hcmt1cCIsIlBheVBhbEJ1dHRvbkNvbXBvbmVudCIsIl9yZWYyIiwiY2FydCIsImV4dGVuc2lvbnMiLCJjYXJ0VG90YWwiLCJjYXJ0VG90YWxzIiwidG90YWxfcHJpY2UiLCJNYXRoIiwicG93IiwiY3VycmVuY3lfbWlub3JfdW5pdCIsImFtb3VudE92ZXJSYW5nZVNldHRpbmciLCJjYXJ0TmVlZHNTaGlwcGluZyIsIlJlYWN0IiwiY3JlYXRlRWxlbWVudCIsImRhbmdlcm91c2x5U2V0SW5uZXJIVE1MIiwiX19odG1sIiwiTW9sbGllUGF5UGFsQnV0dG9uQ2FydCIsInJlbmRlciIsInNjb3BlIiwicGF5UGFsQnV0dG9uIiwicGFyZW50Tm9kZSJdLCJzb3VyY2VSb290IjoiIn0=