/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/js/maybeShowApplePayButton.js":
/*!*************************************************!*\
  !*** ./resources/js/maybeShowApplePayButton.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   maybeShowButton: () => (/* binding */ maybeShowButton)
/* harmony export */ });
var maybeShowButton = function maybeShowButton() {
  var _window = window,
    ApplePaySession = _window.ApplePaySession;
  var applePayMethodElement = document.querySelector('#mollie-applepayDirect-button');
  var canShowButton = applePayMethodElement && ApplePaySession && ApplePaySession.canMakePayments();
  if (!canShowButton) {
    return false;
  }
  var button = document.createElement('button');
  button.setAttribute('id', 'mollie_applepay_button');
  button.classList.add('apple-pay-button');
  button.classList.add('apple-pay-button-black');
  applePayMethodElement.appendChild(button);
  return true;
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**************************************!*\
  !*** ./resources/js/paypalButton.js ***!
  \**************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _maybeShowApplePayButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./maybeShowApplePayButton */ "./resources/js/maybeShowApplePayButton.js");

(function (_ref) {
  var _ = _ref._,
    molliepaypalbutton = _ref.molliepaypalbutton,
    jQuery = _ref.jQuery;
  if (_.isEmpty(molliepaypalbutton)) {
    return;
  }
  var _molliepaypalbutton$p = molliepaypalbutton.product,
    id = _molliepaypalbutton$p.id,
    _molliepaypalbutton$p2 = _molliepaypalbutton$p.needShipping,
    needShipping = _molliepaypalbutton$p2 === void 0 ? true : _molliepaypalbutton$p2,
    _molliepaypalbutton$p3 = _molliepaypalbutton$p.isVariation,
    isVariation = _molliepaypalbutton$p3 === void 0 ? false : _molliepaypalbutton$p3,
    price = _molliepaypalbutton$p.price,
    minFee = _molliepaypalbutton$p.minFee,
    stock = _molliepaypalbutton$p.stock,
    ajaxUrl = molliepaypalbutton.ajaxUrl;
  if (!id || !price || !ajaxUrl) {
    return;
  }
  function getKeyByValue(object, value) {
    return Object.keys(object).find(function (key) {
      return object[key] === value;
    });
  }
  var payPalButton = document.querySelector('#mollie-PayPal-button');
  var buttonParentNode = payPalButton.parentNode;
  var positionKey = false;
  if (buttonParentNode.hasChildNodes()) {
    positionKey = getKeyByValue(buttonParentNode.children, payPalButton);
  }
  var maybeShowButton = function maybeShowButton(underRange) {
    if (underRange) {
      hideButton();
    } else {
      showButton();
    }
  };
  var checkPriceRange = function checkPriceRange(productQuantity) {
    var updatedPrice = productQuantity * price;
    jQuery.ajax({
      url: ajaxUrl,
      method: 'POST',
      data: {
        action: 'mollie_paypal_update_amount',
        productId: productId,
        productQuantity: productQuantity,
        nonce: nonce
      },
      success: function success(response) {
        updatedPrice = parseFloat(response.data);
        var underRange = parseFloat(minFee) > updatedPrice;
        maybeShowButton(underRange);
      },
      error: function error(response) {
        console.warn(response);
      }
    });
  };
  var hideButton = function hideButton() {
    if (buttonParentNode !== null) {
      buttonParentNode.removeChild(payPalButton);
    }
  };
  var showButton = function showButton() {
    //if the node has a list of children, we need to insert the button at the correct position
    var sibling = buttonParentNode.children[positionKey];
    buttonParentNode.insertBefore(payPalButton, sibling);
  };
  var outOfStock = stock === 'outofstock';
  if (outOfStock) {
    hideButton();
    return;
  }
  var nonce = payPalButton.children[0].value;
  var productId = id;
  var productQuantity = 1;
  var redirectionUrl = '';
  document.querySelector('input.qty').addEventListener('change', function (event) {
    productQuantity = event.currentTarget.value;
    checkPriceRange(productQuantity);
  });
  checkPriceRange(productQuantity);
  var fadeButton = function fadeButton() {
    payPalButton.disabled = true;
    payPalButton.classList.add("buttonDisabled");
  };
  if (isVariation) {
    jQuery('.single_variation_wrap').on('show_variation', function (event, variation) {
      productId = '';
      fadeButton();
      // Fired when the user selects all the required dropdowns / attributes
      // and a final variation is selected / shown
      if (variation.is_virtual && variation.is_in_stock && variation.variation_id) {
        productId = variation.variation_id;
        payPalButton.disabled = false;
        payPalButton.classList.remove("buttonDisabled");
      }
    });
    jQuery('.reset_variations').on('click.wc-variation-form', function (event) {
      productId = '';
      fadeButton();
    });
    fadeButton();
  }
  if (payPalButton.parentNode == null) {
    return;
  }
  var preventSpam = false;
  payPalButton.addEventListener('click', function (evt) {
    evt.preventDefault();
    if (!(payPalButton.parentNode !== null) || payPalButton.disabled) {
      return;
    }
    payPalButton.disabled = true;
    payPalButton.classList.add("buttonDisabled");
    if (!preventSpam) {
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_paypal_create_order',
          productId: productId,
          productQuantity: productQuantity,
          needShipping: needShipping,
          'mollie-payments-for-woocommerce_issuer_paypal_button': 'paypal',
          nonce: nonce
        },
        success: function success(response) {
          var result = response.data;
          if (response.success === true) {
            redirectionUrl = result['redirect'];
            window.location.href = redirectionUrl;
          } else {
            console.log(response.data);
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          payPalButton.disabled = false;
          payPalButton.classList.remove("buttonDisabled");
          console.warn(textStatus, errorThrown);
        }
      });
    }
    preventSpam = true;
    if (preventSpam) {
      setTimeout(function () {
        payPalButton.disabled = false;
        payPalButton.classList.remove("buttonDisabled");
        preventSpam = false;
      }, 3000);
    }
  });
})(window);
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGF5cGFsQnV0dG9uLm1pbi5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7OztBQUFPLElBQU1BLGVBQWUsR0FBRyxTQUFsQkEsZUFBZUEsQ0FBQSxFQUFTO0VBQ2pDLElBQUFDLE9BQUEsR0FBMEJDLE1BQU07SUFBekJDLGVBQWUsR0FBQUYsT0FBQSxDQUFmRSxlQUFlO0VBQ3RCLElBQU1DLHFCQUFxQixHQUFHQyxRQUFRLENBQUNDLGFBQWEsQ0FDaEQsK0JBQ0osQ0FBQztFQUNELElBQU1DLGFBQWEsR0FBR0gscUJBQXFCLElBQUtELGVBQWUsSUFBSUEsZUFBZSxDQUFDSyxlQUFlLENBQUMsQ0FBRTtFQUNyRyxJQUFJLENBQUNELGFBQWEsRUFBRTtJQUNoQixPQUFPLEtBQUs7RUFDaEI7RUFDQSxJQUFNRSxNQUFNLEdBQUdKLFFBQVEsQ0FBQ0ssYUFBYSxDQUFDLFFBQVEsQ0FBQztFQUMvQ0QsTUFBTSxDQUFDRSxZQUFZLENBQUMsSUFBSSxFQUFFLHdCQUF3QixDQUFDO0VBQ25ERixNQUFNLENBQUNHLFNBQVMsQ0FBQ0MsR0FBRyxDQUFDLGtCQUFrQixDQUFDO0VBQ3hDSixNQUFNLENBQUNHLFNBQVMsQ0FBQ0MsR0FBRyxDQUFDLHdCQUF3QixDQUFDO0VBQzlDVCxxQkFBcUIsQ0FBQ1UsV0FBVyxDQUFDTCxNQUFNLENBQUM7RUFDekMsT0FBTyxJQUFJO0FBQ2YsQ0FBQzs7Ozs7O1VDZkQ7VUFDQTs7VUFFQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTs7VUFFQTtVQUNBOztVQUVBO1VBQ0E7VUFDQTs7Ozs7V0N0QkE7V0FDQTtXQUNBO1dBQ0E7V0FDQSx5Q0FBeUMsd0NBQXdDO1dBQ2pGO1dBQ0E7V0FDQTs7Ozs7V0NQQTs7Ozs7V0NBQTtXQUNBO1dBQ0E7V0FDQSx1REFBdUQsaUJBQWlCO1dBQ3hFO1dBQ0EsZ0RBQWdELGFBQWE7V0FDN0Q7Ozs7Ozs7Ozs7OztBQ04wRDtBQUUxRCxDQUNJLFVBQUFNLElBQUEsRUFBMkM7RUFBQSxJQUFoQ0MsQ0FBQyxHQUFBRCxJQUFBLENBQURDLENBQUM7SUFBRUMsa0JBQWtCLEdBQUFGLElBQUEsQ0FBbEJFLGtCQUFrQjtJQUFFQyxNQUFNLEdBQUFILElBQUEsQ0FBTkcsTUFBTTtFQUVwQyxJQUFJRixDQUFDLENBQUNHLE9BQU8sQ0FBQ0Ysa0JBQWtCLENBQUMsRUFBRTtJQUMvQjtFQUNKO0VBRUEsSUFBQUcscUJBQUEsR0FBaUdILGtCQUFrQixDQUE1R0ksT0FBTztJQUFHQyxFQUFFLEdBQUFGLHFCQUFBLENBQUZFLEVBQUU7SUFBQUMsc0JBQUEsR0FBQUgscUJBQUEsQ0FBRUksWUFBWTtJQUFaQSxZQUFZLEdBQUFELHNCQUFBLGNBQUcsSUFBSSxHQUFBQSxzQkFBQTtJQUFBRSxzQkFBQSxHQUFBTCxxQkFBQSxDQUFFTSxXQUFXO0lBQVhBLFdBQVcsR0FBQUQsc0JBQUEsY0FBRyxLQUFLLEdBQUFBLHNCQUFBO0lBQUVFLEtBQUssR0FBQVAscUJBQUEsQ0FBTE8sS0FBSztJQUFFQyxNQUFNLEdBQUFSLHFCQUFBLENBQU5RLE1BQU07SUFBRUMsS0FBSyxHQUFBVCxxQkFBQSxDQUFMUyxLQUFLO0lBQUdDLE9BQU8sR0FBSWIsa0JBQWtCLENBQTdCYSxPQUFPO0VBRTdGLElBQUksQ0FBQ1IsRUFBRSxJQUFJLENBQUNLLEtBQUssSUFBSSxDQUFDRyxPQUFPLEVBQUU7SUFDM0I7RUFDSjtFQUNBLFNBQVNDLGFBQWFBLENBQUNDLE1BQU0sRUFBRUMsS0FBSyxFQUFFO0lBQ2xDLE9BQU9DLE1BQU0sQ0FBQ0MsSUFBSSxDQUFDSCxNQUFNLENBQUMsQ0FBQ0ksSUFBSSxDQUFDLFVBQUFDLEdBQUc7TUFBQSxPQUFJTCxNQUFNLENBQUNLLEdBQUcsQ0FBQyxLQUFLSixLQUFLO0lBQUEsRUFBQztFQUNqRTtFQUNBLElBQU1LLFlBQVksR0FBR2pDLFFBQVEsQ0FBQ0MsYUFBYSxDQUFDLHVCQUF1QixDQUFDO0VBQ3BFLElBQU1pQyxnQkFBZ0IsR0FBR0QsWUFBWSxDQUFDRSxVQUFVO0VBQ2hELElBQUlDLFdBQVcsR0FBRyxLQUFLO0VBQ3ZCLElBQUlGLGdCQUFnQixDQUFDRyxhQUFhLENBQUMsQ0FBQyxFQUFFO0lBQ2xDRCxXQUFXLEdBQUdWLGFBQWEsQ0FBQ1EsZ0JBQWdCLENBQUNJLFFBQVEsRUFBRUwsWUFBWSxDQUFDO0VBQ3hFO0VBRUEsSUFBTXRDLGVBQWUsR0FBRyxTQUFsQkEsZUFBZUEsQ0FBSTRDLFVBQVUsRUFBSztJQUNwQyxJQUFHQSxVQUFVLEVBQUM7TUFDVkMsVUFBVSxDQUFDLENBQUM7SUFDaEIsQ0FBQyxNQUFJO01BQ0RDLFVBQVUsQ0FBQyxDQUFDO0lBQ2hCO0VBQ0osQ0FBQztFQUNELElBQU1DLGVBQWUsR0FBRyxTQUFsQkEsZUFBZUEsQ0FBSUMsZUFBZSxFQUFLO0lBQ3pDLElBQUlDLFlBQVksR0FBR0QsZUFBZSxHQUFHckIsS0FBSztJQUMxQ1QsTUFBTSxDQUFDZ0MsSUFBSSxDQUFDO01BQ1JDLEdBQUcsRUFBRXJCLE9BQU87TUFDWnNCLE1BQU0sRUFBRSxNQUFNO01BQ2RDLElBQUksRUFBRTtRQUNGQyxNQUFNLEVBQUUsNkJBQTZCO1FBQ3JDQyxTQUFTLEVBQUVBLFNBQVM7UUFDcEJQLGVBQWUsRUFBRUEsZUFBZTtRQUNoQ1EsS0FBSyxFQUFFQTtNQUNYLENBQUM7TUFDREMsT0FBTyxFQUFFLFNBQUFBLFFBQUNDLFFBQVEsRUFBSztRQUNuQlQsWUFBWSxHQUFHVSxVQUFVLENBQUNELFFBQVEsQ0FBQ0wsSUFBSSxDQUFDO1FBQ3hDLElBQU1ULFVBQVUsR0FBR2UsVUFBVSxDQUFDL0IsTUFBTSxDQUFDLEdBQUdxQixZQUFZO1FBQ3BEakQsZUFBZSxDQUFDNEMsVUFBVSxDQUFDO01BQy9CLENBQUM7TUFDRGdCLEtBQUssRUFBRSxTQUFBQSxNQUFDRixRQUFRLEVBQUs7UUFDakJHLE9BQU8sQ0FBQ0MsSUFBSSxDQUFDSixRQUFRLENBQUM7TUFDMUI7SUFDSixDQUFDLENBQUM7RUFDTixDQUFDO0VBQ0QsSUFBTWIsVUFBVSxHQUFHLFNBQWJBLFVBQVVBLENBQUEsRUFBUztJQUNyQixJQUFHTixnQkFBZ0IsS0FBSyxJQUFJLEVBQUM7TUFDekJBLGdCQUFnQixDQUFDd0IsV0FBVyxDQUFDekIsWUFBWSxDQUFDO0lBQzlDO0VBQ0osQ0FBQztFQUNELElBQU1RLFVBQVUsR0FBRyxTQUFiQSxVQUFVQSxDQUFBLEVBQVM7SUFDckI7SUFDQSxJQUFJa0IsT0FBTyxHQUFHekIsZ0JBQWdCLENBQUNJLFFBQVEsQ0FBQ0YsV0FBVyxDQUFDO0lBQ3BERixnQkFBZ0IsQ0FBQzBCLFlBQVksQ0FBQzNCLFlBQVksRUFBRTBCLE9BQU8sQ0FBQztFQUN4RCxDQUFDO0VBQ0QsSUFBSUUsVUFBVSxHQUFHckMsS0FBSyxLQUFLLFlBQVk7RUFDdkMsSUFBSXFDLFVBQVUsRUFBRTtJQUNackIsVUFBVSxDQUFDLENBQUM7SUFDWjtFQUNKO0VBQ0EsSUFBTVcsS0FBSyxHQUFHbEIsWUFBWSxDQUFDSyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUNWLEtBQUs7RUFDNUMsSUFBSXNCLFNBQVMsR0FBR2pDLEVBQUU7RUFDbEIsSUFBSTBCLGVBQWUsR0FBRyxDQUFDO0VBQ3ZCLElBQUltQixjQUFjLEdBQUcsRUFBRTtFQUN2QjlELFFBQVEsQ0FBQ0MsYUFBYSxDQUFDLFdBQVcsQ0FBQyxDQUFDOEQsZ0JBQWdCLENBQUMsUUFBUSxFQUFFLFVBQUFDLEtBQUssRUFBSTtJQUNwRXJCLGVBQWUsR0FBR3FCLEtBQUssQ0FBQ0MsYUFBYSxDQUFDckMsS0FBSztJQUMzQ2MsZUFBZSxDQUFDQyxlQUFlLENBQUM7RUFDcEMsQ0FBQyxDQUFDO0VBQ0ZELGVBQWUsQ0FBQ0MsZUFBZSxDQUFDO0VBRWhDLElBQU11QixVQUFVLEdBQUcsU0FBYkEsVUFBVUEsQ0FBQSxFQUFTO0lBQ3JCakMsWUFBWSxDQUFDa0MsUUFBUSxHQUFHLElBQUk7SUFDNUJsQyxZQUFZLENBQUMxQixTQUFTLENBQUNDLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQztFQUNoRCxDQUFDO0VBRUQsSUFBSWEsV0FBVyxFQUFFO0lBQ2JSLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDdUQsRUFBRSxDQUFDLGdCQUFnQixFQUFFLFVBQVVKLEtBQUssRUFBRUssU0FBUyxFQUFFO01BQzlFbkIsU0FBUyxHQUFHLEVBQUU7TUFDZGdCLFVBQVUsQ0FBQyxDQUFDO01BQ1o7TUFDQTtNQUNBLElBQUlHLFNBQVMsQ0FBQ0MsVUFBVSxJQUFJRCxTQUFTLENBQUNFLFdBQVcsSUFBSUYsU0FBUyxDQUFDRyxZQUFZLEVBQUU7UUFDekV0QixTQUFTLEdBQUdtQixTQUFTLENBQUNHLFlBQVk7UUFDbEN2QyxZQUFZLENBQUNrQyxRQUFRLEdBQUcsS0FBSztRQUM3QmxDLFlBQVksQ0FBQzFCLFNBQVMsQ0FBQ2tFLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztNQUNuRDtJQUNKLENBQUMsQ0FBQztJQUNGNUQsTUFBTSxDQUFDLG1CQUFtQixDQUFDLENBQUN1RCxFQUFFLENBQUMseUJBQXlCLEVBQUUsVUFBVUosS0FBSyxFQUFFO01BQ3ZFZCxTQUFTLEdBQUcsRUFBRTtNQUNkZ0IsVUFBVSxDQUFDLENBQUM7SUFFaEIsQ0FBQyxDQUFDO0lBQ0ZBLFVBQVUsQ0FBQyxDQUFDO0VBQ2hCO0VBQ0EsSUFBR2pDLFlBQVksQ0FBQ0UsVUFBVSxJQUFJLElBQUksRUFBQztJQUMvQjtFQUNKO0VBQ0EsSUFBSXVDLFdBQVcsR0FBRyxLQUFLO0VBQ3ZCekMsWUFBWSxDQUFDOEIsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLFVBQUNZLEdBQUcsRUFBSztJQUM1Q0EsR0FBRyxDQUFDQyxjQUFjLENBQUMsQ0FBQztJQUNwQixJQUFHLEVBQUUzQyxZQUFZLENBQUNFLFVBQVUsS0FBSyxJQUFJLENBQUMsSUFBSUYsWUFBWSxDQUFDa0MsUUFBUSxFQUFDO01BQzVEO0lBQ0o7SUFDQWxDLFlBQVksQ0FBQ2tDLFFBQVEsR0FBRyxJQUFJO0lBQzVCbEMsWUFBWSxDQUFDMUIsU0FBUyxDQUFDQyxHQUFHLENBQUMsZ0JBQWdCLENBQUM7SUFDNUMsSUFBRyxDQUFDa0UsV0FBVyxFQUFDO01BQ1o3RCxNQUFNLENBQUNnQyxJQUFJLENBQUM7UUFDUkMsR0FBRyxFQUFFckIsT0FBTztRQUNac0IsTUFBTSxFQUFFLE1BQU07UUFDZEMsSUFBSSxFQUFFO1VBQ0ZDLE1BQU0sRUFBRSw0QkFBNEI7VUFDcENDLFNBQVMsRUFBRUEsU0FBUztVQUNwQlAsZUFBZSxFQUFFQSxlQUFlO1VBQ2hDeEIsWUFBWSxFQUFFQSxZQUFZO1VBQzFCLHNEQUFzRCxFQUFFLFFBQVE7VUFDaEVnQyxLQUFLLEVBQUVBO1FBQ1gsQ0FBQztRQUNEQyxPQUFPLEVBQUUsU0FBQUEsUUFBQ0MsUUFBUSxFQUFLO1VBQ25CLElBQUl3QixNQUFNLEdBQUd4QixRQUFRLENBQUNMLElBQUk7VUFFMUIsSUFBSUssUUFBUSxDQUFDRCxPQUFPLEtBQUssSUFBSSxFQUFFO1lBQzNCVSxjQUFjLEdBQUdlLE1BQU0sQ0FBQyxVQUFVLENBQUM7WUFDbkNoRixNQUFNLENBQUNpRixRQUFRLENBQUNDLElBQUksR0FBR2pCLGNBQWM7VUFDekMsQ0FBQyxNQUFNO1lBQ0hOLE9BQU8sQ0FBQ3dCLEdBQUcsQ0FBQzNCLFFBQVEsQ0FBQ0wsSUFBSSxDQUFDO1VBQzlCO1FBQ0osQ0FBQztRQUNETyxLQUFLLEVBQUUsU0FBQUEsTUFBQzBCLEtBQUssRUFBRUMsVUFBVSxFQUFFQyxXQUFXLEVBQUs7VUFDdkNsRCxZQUFZLENBQUNrQyxRQUFRLEdBQUcsS0FBSztVQUM3QmxDLFlBQVksQ0FBQzFCLFNBQVMsQ0FBQ2tFLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztVQUMvQ2pCLE9BQU8sQ0FBQ0MsSUFBSSxDQUFDeUIsVUFBVSxFQUFFQyxXQUFXLENBQUM7UUFDekM7TUFDSixDQUFDLENBQUM7SUFDTjtJQUNBVCxXQUFXLEdBQUcsSUFBSTtJQUNsQixJQUFHQSxXQUFXLEVBQUM7TUFDWFUsVUFBVSxDQUFDLFlBQVc7UUFDbEJuRCxZQUFZLENBQUNrQyxRQUFRLEdBQUcsS0FBSztRQUM3QmxDLFlBQVksQ0FBQzFCLFNBQVMsQ0FBQ2tFLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQ0MsV0FBVyxHQUFHLEtBQUs7TUFDdkIsQ0FBQyxFQUFFLElBQUksQ0FBQztJQUNaO0VBQ0osQ0FBQyxDQUFDO0FBQ04sQ0FBQyxFQUdEN0UsTUFDSixDQUFDLEMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tb2xsaWUtcGF5bWVudHMtZm9yLXdvb2NvbW1lcmNlLy4vcmVzb3VyY2VzL2pzL21heWJlU2hvd0FwcGxlUGF5QnV0dG9uLmpzIiwid2VicGFjazovL21vbGxpZS1wYXltZW50cy1mb3Itd29vY29tbWVyY2Uvd2VicGFjay9ib290c3RyYXAiLCJ3ZWJwYWNrOi8vbW9sbGllLXBheW1lbnRzLWZvci13b29jb21tZXJjZS93ZWJwYWNrL3J1bnRpbWUvZGVmaW5lIHByb3BlcnR5IGdldHRlcnMiLCJ3ZWJwYWNrOi8vbW9sbGllLXBheW1lbnRzLWZvci13b29jb21tZXJjZS93ZWJwYWNrL3J1bnRpbWUvaGFzT3duUHJvcGVydHkgc2hvcnRoYW5kIiwid2VicGFjazovL21vbGxpZS1wYXltZW50cy1mb3Itd29vY29tbWVyY2Uvd2VicGFjay9ydW50aW1lL21ha2UgbmFtZXNwYWNlIG9iamVjdCIsIndlYnBhY2s6Ly9tb2xsaWUtcGF5bWVudHMtZm9yLXdvb2NvbW1lcmNlLy4vcmVzb3VyY2VzL2pzL3BheXBhbEJ1dHRvbi5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgY29uc3QgbWF5YmVTaG93QnV0dG9uID0gKCkgPT4ge1xuICAgIGNvbnN0IHtBcHBsZVBheVNlc3Npb259ID0gd2luZG93XG4gICAgY29uc3QgYXBwbGVQYXlNZXRob2RFbGVtZW50ID0gZG9jdW1lbnQucXVlcnlTZWxlY3RvcihcbiAgICAgICAgJyNtb2xsaWUtYXBwbGVwYXlEaXJlY3QtYnV0dG9uJyxcbiAgICApXG4gICAgY29uc3QgY2FuU2hvd0J1dHRvbiA9IGFwcGxlUGF5TWV0aG9kRWxlbWVudCAmJiAoQXBwbGVQYXlTZXNzaW9uICYmIEFwcGxlUGF5U2Vzc2lvbi5jYW5NYWtlUGF5bWVudHMoKSlcbiAgICBpZiAoIWNhblNob3dCdXR0b24pIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlXG4gICAgfVxuICAgIGNvbnN0IGJ1dHRvbiA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2J1dHRvbicpXG4gICAgYnV0dG9uLnNldEF0dHJpYnV0ZSgnaWQnLCAnbW9sbGllX2FwcGxlcGF5X2J1dHRvbicpXG4gICAgYnV0dG9uLmNsYXNzTGlzdC5hZGQoJ2FwcGxlLXBheS1idXR0b24nKVxuICAgIGJ1dHRvbi5jbGFzc0xpc3QuYWRkKCdhcHBsZS1wYXktYnV0dG9uLWJsYWNrJylcbiAgICBhcHBsZVBheU1ldGhvZEVsZW1lbnQuYXBwZW5kQ2hpbGQoYnV0dG9uKVxuICAgIHJldHVybiB0cnVlXG59XG4iLCIvLyBUaGUgbW9kdWxlIGNhY2hlXG52YXIgX193ZWJwYWNrX21vZHVsZV9jYWNoZV9fID0ge307XG5cbi8vIFRoZSByZXF1aXJlIGZ1bmN0aW9uXG5mdW5jdGlvbiBfX3dlYnBhY2tfcmVxdWlyZV9fKG1vZHVsZUlkKSB7XG5cdC8vIENoZWNrIGlmIG1vZHVsZSBpcyBpbiBjYWNoZVxuXHR2YXIgY2FjaGVkTW9kdWxlID0gX193ZWJwYWNrX21vZHVsZV9jYWNoZV9fW21vZHVsZUlkXTtcblx0aWYgKGNhY2hlZE1vZHVsZSAhPT0gdW5kZWZpbmVkKSB7XG5cdFx0cmV0dXJuIGNhY2hlZE1vZHVsZS5leHBvcnRzO1xuXHR9XG5cdC8vIENyZWF0ZSBhIG5ldyBtb2R1bGUgKGFuZCBwdXQgaXQgaW50byB0aGUgY2FjaGUpXG5cdHZhciBtb2R1bGUgPSBfX3dlYnBhY2tfbW9kdWxlX2NhY2hlX19bbW9kdWxlSWRdID0ge1xuXHRcdC8vIG5vIG1vZHVsZS5pZCBuZWVkZWRcblx0XHQvLyBubyBtb2R1bGUubG9hZGVkIG5lZWRlZFxuXHRcdGV4cG9ydHM6IHt9XG5cdH07XG5cblx0Ly8gRXhlY3V0ZSB0aGUgbW9kdWxlIGZ1bmN0aW9uXG5cdF9fd2VicGFja19tb2R1bGVzX19bbW9kdWxlSWRdKG1vZHVsZSwgbW9kdWxlLmV4cG9ydHMsIF9fd2VicGFja19yZXF1aXJlX18pO1xuXG5cdC8vIFJldHVybiB0aGUgZXhwb3J0cyBvZiB0aGUgbW9kdWxlXG5cdHJldHVybiBtb2R1bGUuZXhwb3J0cztcbn1cblxuIiwiLy8gZGVmaW5lIGdldHRlciBmdW5jdGlvbnMgZm9yIGhhcm1vbnkgZXhwb3J0c1xuX193ZWJwYWNrX3JlcXVpcmVfXy5kID0gKGV4cG9ydHMsIGRlZmluaXRpb24pID0+IHtcblx0Zm9yKHZhciBrZXkgaW4gZGVmaW5pdGlvbikge1xuXHRcdGlmKF9fd2VicGFja19yZXF1aXJlX18ubyhkZWZpbml0aW9uLCBrZXkpICYmICFfX3dlYnBhY2tfcmVxdWlyZV9fLm8oZXhwb3J0cywga2V5KSkge1xuXHRcdFx0T2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIGtleSwgeyBlbnVtZXJhYmxlOiB0cnVlLCBnZXQ6IGRlZmluaXRpb25ba2V5XSB9KTtcblx0XHR9XG5cdH1cbn07IiwiX193ZWJwYWNrX3JlcXVpcmVfXy5vID0gKG9iaiwgcHJvcCkgPT4gKE9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHkuY2FsbChvYmosIHByb3ApKSIsIi8vIGRlZmluZSBfX2VzTW9kdWxlIG9uIGV4cG9ydHNcbl9fd2VicGFja19yZXF1aXJlX18uciA9IChleHBvcnRzKSA9PiB7XG5cdGlmKHR5cGVvZiBTeW1ib2wgIT09ICd1bmRlZmluZWQnICYmIFN5bWJvbC50b1N0cmluZ1RhZykge1xuXHRcdE9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBTeW1ib2wudG9TdHJpbmdUYWcsIHsgdmFsdWU6ICdNb2R1bGUnIH0pO1xuXHR9XG5cdE9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCAnX19lc01vZHVsZScsIHsgdmFsdWU6IHRydWUgfSk7XG59OyIsImltcG9ydCB7bWF5YmVTaG93QnV0dG9ufSBmcm9tIFwiLi9tYXliZVNob3dBcHBsZVBheUJ1dHRvblwiO1xuXG4oXG4gICAgZnVuY3Rpb24gKHtfLCBtb2xsaWVwYXlwYWxidXR0b24sIGpRdWVyeX0pIHtcblxuICAgICAgICBpZiAoXy5pc0VtcHR5KG1vbGxpZXBheXBhbGJ1dHRvbikpIHtcbiAgICAgICAgICAgIHJldHVyblxuICAgICAgICB9XG5cbiAgICAgICAgY29uc3Qge3Byb2R1Y3Q6IHtpZCwgbmVlZFNoaXBwaW5nID0gdHJ1ZSwgaXNWYXJpYXRpb24gPSBmYWxzZSwgcHJpY2UsIG1pbkZlZSwgc3RvY2t9LCBhamF4VXJsfSA9IG1vbGxpZXBheXBhbGJ1dHRvblxuXG4gICAgICAgIGlmICghaWQgfHwgIXByaWNlIHx8ICFhamF4VXJsKSB7XG4gICAgICAgICAgICByZXR1cm5cbiAgICAgICAgfVxuICAgICAgICBmdW5jdGlvbiBnZXRLZXlCeVZhbHVlKG9iamVjdCwgdmFsdWUpIHtcbiAgICAgICAgICAgIHJldHVybiBPYmplY3Qua2V5cyhvYmplY3QpLmZpbmQoa2V5ID0+IG9iamVjdFtrZXldID09PSB2YWx1ZSk7XG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgcGF5UGFsQnV0dG9uID0gZG9jdW1lbnQucXVlcnlTZWxlY3RvcignI21vbGxpZS1QYXlQYWwtYnV0dG9uJyk7XG4gICAgICAgIGNvbnN0IGJ1dHRvblBhcmVudE5vZGUgPSBwYXlQYWxCdXR0b24ucGFyZW50Tm9kZTtcbiAgICAgICAgbGV0IHBvc2l0aW9uS2V5ID0gZmFsc2U7XG4gICAgICAgIGlmIChidXR0b25QYXJlbnROb2RlLmhhc0NoaWxkTm9kZXMoKSkge1xuICAgICAgICAgICAgcG9zaXRpb25LZXkgPSBnZXRLZXlCeVZhbHVlKGJ1dHRvblBhcmVudE5vZGUuY2hpbGRyZW4sIHBheVBhbEJ1dHRvbik7XG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCBtYXliZVNob3dCdXR0b24gPSAodW5kZXJSYW5nZSkgPT4ge1xuICAgICAgICAgICAgaWYodW5kZXJSYW5nZSl7XG4gICAgICAgICAgICAgICAgaGlkZUJ1dHRvbigpXG4gICAgICAgICAgICB9ZWxzZXtcbiAgICAgICAgICAgICAgICBzaG93QnV0dG9uKClcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBjb25zdCBjaGVja1ByaWNlUmFuZ2UgPSAocHJvZHVjdFF1YW50aXR5KSA9PiB7XG4gICAgICAgICAgICBsZXQgdXBkYXRlZFByaWNlID0gcHJvZHVjdFF1YW50aXR5ICogcHJpY2VcbiAgICAgICAgICAgIGpRdWVyeS5hamF4KHtcbiAgICAgICAgICAgICAgICB1cmw6IGFqYXhVcmwsXG4gICAgICAgICAgICAgICAgbWV0aG9kOiAnUE9TVCcsXG4gICAgICAgICAgICAgICAgZGF0YToge1xuICAgICAgICAgICAgICAgICAgICBhY3Rpb246ICdtb2xsaWVfcGF5cGFsX3VwZGF0ZV9hbW91bnQnLFxuICAgICAgICAgICAgICAgICAgICBwcm9kdWN0SWQ6IHByb2R1Y3RJZCxcbiAgICAgICAgICAgICAgICAgICAgcHJvZHVjdFF1YW50aXR5OiBwcm9kdWN0UXVhbnRpdHksXG4gICAgICAgICAgICAgICAgICAgIG5vbmNlOiBub25jZSxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIHN1Y2Nlc3M6IChyZXNwb25zZSkgPT4ge1xuICAgICAgICAgICAgICAgICAgICB1cGRhdGVkUHJpY2UgPSBwYXJzZUZsb2F0KHJlc3BvbnNlLmRhdGEpXG4gICAgICAgICAgICAgICAgICAgIGNvbnN0IHVuZGVyUmFuZ2UgPSBwYXJzZUZsb2F0KG1pbkZlZSkgPiB1cGRhdGVkUHJpY2VcbiAgICAgICAgICAgICAgICAgICAgbWF5YmVTaG93QnV0dG9uKHVuZGVyUmFuZ2UpXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBlcnJvcjogKHJlc3BvbnNlKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgIGNvbnNvbGUud2FybihyZXNwb25zZSlcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSlcbiAgICAgICAgfVxuICAgICAgICBjb25zdCBoaWRlQnV0dG9uID0gKCkgPT4ge1xuICAgICAgICAgICAgaWYoYnV0dG9uUGFyZW50Tm9kZSAhPT0gbnVsbCl7XG4gICAgICAgICAgICAgICAgYnV0dG9uUGFyZW50Tm9kZS5yZW1vdmVDaGlsZChwYXlQYWxCdXR0b24pXG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgY29uc3Qgc2hvd0J1dHRvbiA9ICgpID0+IHtcbiAgICAgICAgICAgIC8vaWYgdGhlIG5vZGUgaGFzIGEgbGlzdCBvZiBjaGlsZHJlbiwgd2UgbmVlZCB0byBpbnNlcnQgdGhlIGJ1dHRvbiBhdCB0aGUgY29ycmVjdCBwb3NpdGlvblxuICAgICAgICAgICAgbGV0IHNpYmxpbmcgPSBidXR0b25QYXJlbnROb2RlLmNoaWxkcmVuW3Bvc2l0aW9uS2V5XVxuICAgICAgICAgICAgYnV0dG9uUGFyZW50Tm9kZS5pbnNlcnRCZWZvcmUocGF5UGFsQnV0dG9uLCBzaWJsaW5nKVxuICAgICAgICB9XG4gICAgICAgIGxldCBvdXRPZlN0b2NrID0gc3RvY2sgPT09ICdvdXRvZnN0b2NrJ1xuICAgICAgICBpZiAob3V0T2ZTdG9jaykge1xuICAgICAgICAgICAgaGlkZUJ1dHRvbigpXG4gICAgICAgICAgICByZXR1cm5cbiAgICAgICAgfVxuICAgICAgICBjb25zdCBub25jZSA9IHBheVBhbEJ1dHRvbi5jaGlsZHJlblswXS52YWx1ZVxuICAgICAgICBsZXQgcHJvZHVjdElkID0gaWRcbiAgICAgICAgbGV0IHByb2R1Y3RRdWFudGl0eSA9IDFcbiAgICAgICAgbGV0IHJlZGlyZWN0aW9uVXJsID0gJydcbiAgICAgICAgZG9jdW1lbnQucXVlcnlTZWxlY3RvcignaW5wdXQucXR5JykuYWRkRXZlbnRMaXN0ZW5lcignY2hhbmdlJywgZXZlbnQgPT4ge1xuICAgICAgICAgICAgcHJvZHVjdFF1YW50aXR5ID0gZXZlbnQuY3VycmVudFRhcmdldC52YWx1ZVxuICAgICAgICAgICAgY2hlY2tQcmljZVJhbmdlKHByb2R1Y3RRdWFudGl0eSlcbiAgICAgICAgfSlcbiAgICAgICAgY2hlY2tQcmljZVJhbmdlKHByb2R1Y3RRdWFudGl0eSlcblxuICAgICAgICBjb25zdCBmYWRlQnV0dG9uID0gKCkgPT4ge1xuICAgICAgICAgICAgcGF5UGFsQnV0dG9uLmRpc2FibGVkID0gdHJ1ZTtcbiAgICAgICAgICAgIHBheVBhbEJ1dHRvbi5jbGFzc0xpc3QuYWRkKFwiYnV0dG9uRGlzYWJsZWRcIik7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoaXNWYXJpYXRpb24pIHtcbiAgICAgICAgICAgIGpRdWVyeSgnLnNpbmdsZV92YXJpYXRpb25fd3JhcCcpLm9uKCdzaG93X3ZhcmlhdGlvbicsIGZ1bmN0aW9uIChldmVudCwgdmFyaWF0aW9uKSB7XG4gICAgICAgICAgICAgICAgcHJvZHVjdElkID0gJydcbiAgICAgICAgICAgICAgICBmYWRlQnV0dG9uKCk7XG4gICAgICAgICAgICAgICAgLy8gRmlyZWQgd2hlbiB0aGUgdXNlciBzZWxlY3RzIGFsbCB0aGUgcmVxdWlyZWQgZHJvcGRvd25zIC8gYXR0cmlidXRlc1xuICAgICAgICAgICAgICAgIC8vIGFuZCBhIGZpbmFsIHZhcmlhdGlvbiBpcyBzZWxlY3RlZCAvIHNob3duXG4gICAgICAgICAgICAgICAgaWYgKHZhcmlhdGlvbi5pc192aXJ0dWFsICYmIHZhcmlhdGlvbi5pc19pbl9zdG9jayAmJiB2YXJpYXRpb24udmFyaWF0aW9uX2lkKSB7XG4gICAgICAgICAgICAgICAgICAgIHByb2R1Y3RJZCA9IHZhcmlhdGlvbi52YXJpYXRpb25faWRcbiAgICAgICAgICAgICAgICAgICAgcGF5UGFsQnV0dG9uLmRpc2FibGVkID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgICAgIHBheVBhbEJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKFwiYnV0dG9uRGlzYWJsZWRcIik7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICBqUXVlcnkoJy5yZXNldF92YXJpYXRpb25zJykub24oJ2NsaWNrLndjLXZhcmlhdGlvbi1mb3JtJywgZnVuY3Rpb24gKGV2ZW50KSB7XG4gICAgICAgICAgICAgICAgcHJvZHVjdElkID0gJydcbiAgICAgICAgICAgICAgICBmYWRlQnV0dG9uKCk7XG5cbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgZmFkZUJ1dHRvbigpO1xuICAgICAgICB9XG4gICAgICAgIGlmKHBheVBhbEJ1dHRvbi5wYXJlbnROb2RlID09IG51bGwpe1xuICAgICAgICAgICAgcmV0dXJuXG4gICAgICAgIH1cbiAgICAgICAgbGV0IHByZXZlbnRTcGFtID0gZmFsc2VcbiAgICAgICAgcGF5UGFsQnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgKGV2dCkgPT4ge1xuICAgICAgICAgICAgZXZ0LnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgICAgICBpZighKHBheVBhbEJ1dHRvbi5wYXJlbnROb2RlICE9PSBudWxsKSB8fCBwYXlQYWxCdXR0b24uZGlzYWJsZWQpe1xuICAgICAgICAgICAgICAgIHJldHVyblxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcGF5UGFsQnV0dG9uLmRpc2FibGVkID0gdHJ1ZTtcbiAgICAgICAgICAgIHBheVBhbEJ1dHRvbi5jbGFzc0xpc3QuYWRkKFwiYnV0dG9uRGlzYWJsZWRcIik7XG4gICAgICAgICAgICBpZighcHJldmVudFNwYW0pe1xuICAgICAgICAgICAgICAgIGpRdWVyeS5hamF4KHtcbiAgICAgICAgICAgICAgICAgICAgdXJsOiBhamF4VXJsLFxuICAgICAgICAgICAgICAgICAgICBtZXRob2Q6ICdQT1NUJyxcbiAgICAgICAgICAgICAgICAgICAgZGF0YToge1xuICAgICAgICAgICAgICAgICAgICAgICAgYWN0aW9uOiAnbW9sbGllX3BheXBhbF9jcmVhdGVfb3JkZXInLFxuICAgICAgICAgICAgICAgICAgICAgICAgcHJvZHVjdElkOiBwcm9kdWN0SWQsXG4gICAgICAgICAgICAgICAgICAgICAgICBwcm9kdWN0UXVhbnRpdHk6IHByb2R1Y3RRdWFudGl0eSxcbiAgICAgICAgICAgICAgICAgICAgICAgIG5lZWRTaGlwcGluZzogbmVlZFNoaXBwaW5nLFxuICAgICAgICAgICAgICAgICAgICAgICAgJ21vbGxpZS1wYXltZW50cy1mb3Itd29vY29tbWVyY2VfaXNzdWVyX3BheXBhbF9idXR0b24nOiAncGF5cGFsJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIG5vbmNlOiBub25jZSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgc3VjY2VzczogKHJlc3BvbnNlKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBsZXQgcmVzdWx0ID0gcmVzcG9uc2UuZGF0YVxuXG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAocmVzcG9uc2Uuc3VjY2VzcyA9PT0gdHJ1ZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlZGlyZWN0aW9uVXJsID0gcmVzdWx0WydyZWRpcmVjdCddO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHdpbmRvdy5sb2NhdGlvbi5ocmVmID0gcmVkaXJlY3Rpb25VcmxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29uc29sZS5sb2cocmVzcG9uc2UuZGF0YSlcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgZXJyb3I6IChqcVhIUiwgdGV4dFN0YXR1cywgZXJyb3JUaHJvd24pID0+IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHBheVBhbEJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlO1xuICAgICAgICAgICAgICAgICAgICAgICAgcGF5UGFsQnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoXCJidXR0b25EaXNhYmxlZFwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnNvbGUud2Fybih0ZXh0U3RhdHVzLCBlcnJvclRocm93bilcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcHJldmVudFNwYW0gPSB0cnVlXG4gICAgICAgICAgICBpZihwcmV2ZW50U3BhbSl7XG4gICAgICAgICAgICAgICAgc2V0VGltZW91dChmdW5jdGlvbigpIHtcbiAgICAgICAgICAgICAgICAgICAgcGF5UGFsQnV0dG9uLmRpc2FibGVkID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgICAgIHBheVBhbEJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKFwiYnV0dG9uRGlzYWJsZWRcIik7XG4gICAgICAgICAgICAgICAgICAgIHByZXZlbnRTcGFtID0gZmFsc2VcbiAgICAgICAgICAgICAgICB9LCAzMDAwKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSlcbiAgICB9XG4pXG4oXG4gICAgd2luZG93XG4pXG5cblxuXG4iXSwibmFtZXMiOlsibWF5YmVTaG93QnV0dG9uIiwiX3dpbmRvdyIsIndpbmRvdyIsIkFwcGxlUGF5U2Vzc2lvbiIsImFwcGxlUGF5TWV0aG9kRWxlbWVudCIsImRvY3VtZW50IiwicXVlcnlTZWxlY3RvciIsImNhblNob3dCdXR0b24iLCJjYW5NYWtlUGF5bWVudHMiLCJidXR0b24iLCJjcmVhdGVFbGVtZW50Iiwic2V0QXR0cmlidXRlIiwiY2xhc3NMaXN0IiwiYWRkIiwiYXBwZW5kQ2hpbGQiLCJfcmVmIiwiXyIsIm1vbGxpZXBheXBhbGJ1dHRvbiIsImpRdWVyeSIsImlzRW1wdHkiLCJfbW9sbGllcGF5cGFsYnV0dG9uJHAiLCJwcm9kdWN0IiwiaWQiLCJfbW9sbGllcGF5cGFsYnV0dG9uJHAyIiwibmVlZFNoaXBwaW5nIiwiX21vbGxpZXBheXBhbGJ1dHRvbiRwMyIsImlzVmFyaWF0aW9uIiwicHJpY2UiLCJtaW5GZWUiLCJzdG9jayIsImFqYXhVcmwiLCJnZXRLZXlCeVZhbHVlIiwib2JqZWN0IiwidmFsdWUiLCJPYmplY3QiLCJrZXlzIiwiZmluZCIsImtleSIsInBheVBhbEJ1dHRvbiIsImJ1dHRvblBhcmVudE5vZGUiLCJwYXJlbnROb2RlIiwicG9zaXRpb25LZXkiLCJoYXNDaGlsZE5vZGVzIiwiY2hpbGRyZW4iLCJ1bmRlclJhbmdlIiwiaGlkZUJ1dHRvbiIsInNob3dCdXR0b24iLCJjaGVja1ByaWNlUmFuZ2UiLCJwcm9kdWN0UXVhbnRpdHkiLCJ1cGRhdGVkUHJpY2UiLCJhamF4IiwidXJsIiwibWV0aG9kIiwiZGF0YSIsImFjdGlvbiIsInByb2R1Y3RJZCIsIm5vbmNlIiwic3VjY2VzcyIsInJlc3BvbnNlIiwicGFyc2VGbG9hdCIsImVycm9yIiwiY29uc29sZSIsIndhcm4iLCJyZW1vdmVDaGlsZCIsInNpYmxpbmciLCJpbnNlcnRCZWZvcmUiLCJvdXRPZlN0b2NrIiwicmVkaXJlY3Rpb25VcmwiLCJhZGRFdmVudExpc3RlbmVyIiwiZXZlbnQiLCJjdXJyZW50VGFyZ2V0IiwiZmFkZUJ1dHRvbiIsImRpc2FibGVkIiwib24iLCJ2YXJpYXRpb24iLCJpc192aXJ0dWFsIiwiaXNfaW5fc3RvY2siLCJ2YXJpYXRpb25faWQiLCJyZW1vdmUiLCJwcmV2ZW50U3BhbSIsImV2dCIsInByZXZlbnREZWZhdWx0IiwicmVzdWx0IiwibG9jYXRpb24iLCJocmVmIiwibG9nIiwianFYSFIiLCJ0ZXh0U3RhdHVzIiwiZXJyb3JUaHJvd24iLCJzZXRUaW1lb3V0Il0sInNvdXJjZVJvb3QiOiIifQ==