/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/js/applePayError.js":
/*!***************************************!*\
  !*** ./resources/js/applePayError.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createAppleErrors: () => (/* binding */ createAppleErrors)
/* harmony export */ });
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function createAppleErrors(errors) {
  var errorList = [];
  var _iterator = _createForOfIteratorHelper(errors),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var error = _step.value;
      var _error$contactField = error.contactField,
        contactField = _error$contactField === void 0 ? null : _error$contactField,
        _error$code = error.code,
        code = _error$code === void 0 ? null : _error$code,
        _error$message = error.message,
        message = _error$message === void 0 ? null : _error$message;
      var appleError = contactField ? new ApplePayError(code, contactField, message) : new ApplePayError(code);
      errorList.push(appleError);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return errorList;
}

/***/ }),

/***/ "./resources/js/applePayRequest.js":
/*!*****************************************!*\
  !*** ./resources/js/applePayRequest.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   request: () => (/* binding */ request)
/* harmony export */ });
var request = function request(countryCode, currencyCode, totalLabel, subtotal) {
  return {
    countryCode: countryCode,
    currencyCode: currencyCode,
    supportedNetworks: ['amex', 'maestro', 'masterCard', 'visa', 'vPay'],
    merchantCapabilities: ['supports3DS'],
    shippingType: 'shipping',
    requiredBillingContactFields: ['postalAddress', 'email'],
    requiredShippingContactFields: ['postalAddress', 'email'],
    total: {
      label: totalLabel,
      amount: subtotal,
      type: 'final'
    }
  };
};

/***/ }),

/***/ "./resources/js/blocks/ApplePayButtonComponent.js":
/*!********************************************************!*\
  !*** ./resources/js/blocks/ApplePayButtonComponent.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ApplePayButtonComponent: () => (/* binding */ ApplePayButtonComponent),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _applePayRequest__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../applePayRequest */ "./resources/js/applePayRequest.js");
/* harmony import */ var _applePayError__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../applePayError */ "./resources/js/applePayError.js");


var ApplePayButtonComponent = function ApplePayButtonComponent(_ref) {
  var _ref$buttonAttributes = _ref.buttonAttributes,
    buttonAttributes = _ref$buttonAttributes === void 0 ? {} : _ref$buttonAttributes;
  var mollieApplePayBlockDataCart = window.mollieApplePayBlockDataCart || window.mollieBlockData.mollieApplePayBlockDataCart;
  var nonce = document.getElementById("woocommerce-process-checkout-nonce").value;
  var updatedContactInfo = [];
  var redirectionUrl = '';
  var _mollieApplePayBlockD = mollieApplePayBlockDataCart.product,
    _mollieApplePayBlockD2 = _mollieApplePayBlockD.needShipping,
    needShipping = _mollieApplePayBlockD2 === void 0 ? true : _mollieApplePayBlockD2,
    subtotal = _mollieApplePayBlockD.subtotal,
    _mollieApplePayBlockD3 = mollieApplePayBlockDataCart.shop,
    countryCode = _mollieApplePayBlockD3.countryCode,
    _mollieApplePayBlockD4 = _mollieApplePayBlockD3.currencyCode,
    currencyCode = _mollieApplePayBlockD4 === void 0 ? 'EUR' : _mollieApplePayBlockD4,
    _mollieApplePayBlockD5 = _mollieApplePayBlockD3.totalLabel,
    totalLabel = _mollieApplePayBlockD5 === void 0 ? '' : _mollieApplePayBlockD5,
    ajaxUrl = mollieApplePayBlockDataCart.ajaxUrl;
  var style = {
    height: "".concat(buttonAttributes.height || 48, "px"),
    borderRadius: "".concat(buttonAttributes.borderRadius || 4, "px")
  };
  var findSelectedShippingMethod = function findSelectedShippingMethod(shippingRates) {
    var shippingRate = shippingRates.find(function (shippingMethod) {
      return shippingMethod.selected === true;
    });
    var appleFormattedRate = {
      amount: '',
      detail: '',
      label: shippingRate.name,
      identifier: shippingRate.rate_id,
      selected: shippingRate.selected
    };
    return shippingRate ? appleFormattedRate : '';
  };
  var applePaySession = function applePaySession() {
    var _store$getShippingRat;
    var session = new ApplePaySession(3, (0,_applePayRequest__WEBPACK_IMPORTED_MODULE_0__.request)(countryCode, currencyCode, totalLabel, subtotal));
    var store = wp.data.select('wc/store/cart');
    var shippingRates = (_store$getShippingRat = store.getShippingRates()) === null || _store$getShippingRat === void 0 || (_store$getShippingRat = _store$getShippingRat[0]) === null || _store$getShippingRat === void 0 ? void 0 : _store$getShippingRat.shipping_rates;
    var selectedShippingMethod = '';
    if (shippingRates && shippingRates.length > 0) {
      selectedShippingMethod = findSelectedShippingMethod(shippingRates, selectedShippingMethod);
    }
    session.onshippingmethodselected = function (event) {
      var _this = this;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_update_shipping_method',
          shippingMethod: event.shippingMethod,
          callerPage: 'cart',
          simplifiedContact: updatedContactInfo,
          'woocommerce-process-checkout-nonce': nonce
        },
        success: function success(applePayShippingMethodUpdate, textStatus, jqXHR) {
          var response = applePayShippingMethodUpdate.data;
          selectedShippingMethod = event.shippingMethod;
          if (applePayShippingMethodUpdate.success === false) {
            response.errors = (0,_applePayError__WEBPACK_IMPORTED_MODULE_1__.createAppleErrors)(response.errors);
          }
          _this.completeShippingMethodSelection(response);
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onshippingcontactselected = function (event) {
      var _this2 = this;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_update_shipping_contact',
          simplifiedContact: event.shippingContact,
          callerPage: 'cart',
          needShipping: needShipping,
          'woocommerce-process-checkout-nonce': nonce,
          shippingMethod: selectedShippingMethod
        },
        success: function success(applePayShippingContactUpdate, textStatus, jqXHR) {
          var response = applePayShippingContactUpdate.data;
          updatedContactInfo = event.shippingContact;
          if (applePayShippingContactUpdate.success === false) {
            response.errors = (0,_applePayError__WEBPACK_IMPORTED_MODULE_1__.createAppleErrors)(response.errors);
          }
          if (response.newShippingMethods) {
            selectedShippingMethod = response.newShippingMethods[0];
          }
          _this2.completeShippingContactSelection(response);
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onvalidatemerchant = function (applePayValidateMerchantEvent) {
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_validation',
          validationUrl: applePayValidateMerchantEvent.validationURL,
          'woocommerce-process-checkout-nonce': nonce
        },
        success: function success(merchantSession, textStatus, jqXHR) {
          if (merchantSession.success === true) {
            session.completeMerchantValidation(JSON.parse(merchantSession.data));
          } else {
            console.warn(merchantSession.data);
            session.abort();
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onpaymentauthorized = function (ApplePayPayment) {
      var _ApplePayPayment$paym = ApplePayPayment.payment,
        billingContact = _ApplePayPayment$paym.billingContact,
        shippingContact = _ApplePayPayment$paym.shippingContact;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_create_order_cart',
          shippingContact: ApplePayPayment.payment.shippingContact,
          billingContact: ApplePayPayment.payment.billingContact,
          token: ApplePayPayment.payment.token,
          shippingMethod: selectedShippingMethod,
          'mollie-payments-for-woocommerce_issuer_applepay': 'applepay',
          'woocommerce-process-checkout-nonce': nonce,
          'billing_first_name': billingContact.givenName || '',
          'billing_last_name': billingContact.familyName || '',
          'billing_company': '',
          'billing_country': billingContact.countryCode || '',
          'billing_address_1': billingContact.addressLines[0] || '',
          'billing_address_2': billingContact.addressLines[1] || '',
          'billing_postcode': billingContact.postalCode || '',
          'billing_city': billingContact.locality || '',
          'billing_state': billingContact.administrativeArea || '',
          'billing_phone': billingContact.phoneNumber || '000000000000',
          'billing_email': shippingContact.emailAddress || '',
          'shipping_first_name': shippingContact.givenName || '',
          'shipping_last_name': shippingContact.familyName || '',
          'shipping_company': '',
          'shipping_country': shippingContact.countryCode || '',
          'shipping_address_1': shippingContact.addressLines[0] || '',
          'shipping_address_2': shippingContact.addressLines[1] || '',
          'shipping_postcode': shippingContact.postalCode || '',
          'shipping_city': shippingContact.locality || '',
          'shipping_state': shippingContact.administrativeArea || '',
          'shipping_phone': shippingContact.phoneNumber || '000000000000',
          'shipping_email': shippingContact.emailAddress || '',
          'order_comments': '',
          'payment_method': 'mollie_wc_gateway_applepay',
          '_wp_http_referer': '/?wc-ajax=update_order_review'
        },
        success: function success(authorizationResult, textStatus, jqXHR) {
          var result = authorizationResult.data;
          if (authorizationResult.success === true) {
            redirectionUrl = result['returnUrl'];
            session.completePayment(result['responseToApple']);
            window.location.href = redirectionUrl;
          } else {
            result.errors = (0,_applePayError__WEBPACK_IMPORTED_MODULE_1__.createAppleErrors)(result.errors);
            session.completePayment(result);
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.begin();
  };
  return /*#__PURE__*/React.createElement("button", {
    id: "mollie_applepay_button",
    className: "apple-pay-button apple-pay-button-black",
    onClick: function onClick(event) {
      event.preventDefault();
      applePaySession();
    },
    style: style
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApplePayButtonComponent);

/***/ }),

/***/ "./resources/js/blocks/ApplePayButtonEditorComponent.js":
/*!**************************************************************!*\
  !*** ./resources/js/blocks/ApplePayButtonEditorComponent.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ApplePayButtonEditorComponent: () => (/* binding */ ApplePayButtonEditorComponent),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var ApplePayButtonEditorComponent = function ApplePayButtonEditorComponent(_ref) {
  var _ref$buttonAttributes = _ref.buttonAttributes,
    buttonAttributes = _ref$buttonAttributes === void 0 ? {} : _ref$buttonAttributes;
  var style = {
    height: "".concat(buttonAttributes.height || 48, "px"),
    borderRadius: "".concat(buttonAttributes.borderRadius || 4, "px")
  };
  return /*#__PURE__*/React.createElement("button", {
    id: "mollie_applepay_button",
    className: "apple-pay-button apple-pay-button-black",
    style: style
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApplePayButtonEditorComponent);

/***/ }),

/***/ "./resources/js/blocks/molliePaymentMethod.js":
/*!****************************************************!*\
  !*** ./resources/js/blocks/molliePaymentMethod.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var cachedAvailableGateways = {};
function setAvailableGateways(country, currencyCode, data) {
  cachedAvailableGateways = _objectSpread(_objectSpread({}, cachedAvailableGateways), data);
}
function useMollieAvailableGateways(billing, currencyCode, cartTotal, filters, ajaxUrl) {
  var country = billing.country;
  var code = currencyCode;
  var value = cartTotal;
  if (!country) {
    var _wcSettings;
    country = (_wcSettings = wcSettings) === null || _wcSettings === void 0 ? void 0 : _wcSettings.baseLocation.country;
  }
  wp.element.useEffect(function () {
    if (!country) return;
    var currencyCode = code;
    var cartTotal = value;
    var currentFilterKey = currencyCode + "-" + country;
    if (cachedAvailableGateways.hasOwnProperty(currentFilterKey)) {
      return;
    }
    fetch(ajaxUrl, {
      method: 'POST',
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      body: new URLSearchParams({
        action: 'mollie_checkout_blocks_canmakepayment',
        currency: currencyCode,
        billingCountry: country,
        cartTotal: cartTotal,
        paymentLocale: filters.paymentLocale
      })
    }).then(function (response) {
      return response.json();
    }).then(function (data) {
      setAvailableGateways(country, currencyCode, data.data);
      var cartTotals = wp.data.select('wc/store/cart').getCartTotals();
      // Dispatch them again to trigger a re-render:
      wp.data.dispatch('wc/store/cart').setCartData(_objectSpread({}, cartTotals));
    });
  }, [billing, currencyCode, filters.paymentLocale]);
  return cachedAvailableGateways;
}

// Component that runs the hook but does not render anything.
function MollieGatewayUpdater(_ref) {
  var billing = _ref.billing,
    currencyCode = _ref.currencyCode,
    cartTotal = _ref.cartTotal,
    filters = _ref.filters,
    ajaxUrl = _ref.ajaxUrl;
  useMollieAvailableGateways(billing, currencyCode, cartTotal, filters, ajaxUrl);
  return null;
}
var onSubmitLocal;
var activePaymentMethodLocal;
var creditCardSelected = new Event("mollie_creditcard_component_selected", {
  bubbles: true
});
var MollieComponent = function MollieComponent(props) {
  var onSubmit = props.onSubmit,
    activePaymentMethod = props.activePaymentMethod,
    billing = props.billing,
    item = props.item,
    useEffect = props.useEffect,
    ajaxUrl = props.ajaxUrl,
    jQuery = props.jQuery,
    emitResponse = props.emitResponse,
    eventRegistration = props.eventRegistration,
    requiredFields = props.requiredFields,
    shippingData = props.shippingData,
    isPhoneFieldVisible = props.isPhoneFieldVisible;
  var responseTypes = emitResponse.responseTypes;
  var onPaymentSetup = eventRegistration.onPaymentSetup,
    onCheckoutValidation = eventRegistration.onCheckoutValidation;
  if (!item || !item.name) {
    return /*#__PURE__*/React.createElement("div", null, "Loading payment methods...");
  }
  var _wp$element$useState = wp.element.useState(''),
    _wp$element$useState2 = _slicedToArray(_wp$element$useState, 2),
    selectedIssuer = _wp$element$useState2[0],
    selectIssuer = _wp$element$useState2[1];
  var _wp$element$useState3 = wp.element.useState(''),
    _wp$element$useState4 = _slicedToArray(_wp$element$useState3, 2),
    inputPhone = _wp$element$useState4[0],
    selectPhone = _wp$element$useState4[1];
  var _wp$element$useState5 = wp.element.useState(''),
    _wp$element$useState6 = _slicedToArray(_wp$element$useState5, 2),
    inputBirthdate = _wp$element$useState6[0],
    selectBirthdate = _wp$element$useState6[1];
  var _wp$element$useState7 = wp.element.useState(''),
    _wp$element$useState8 = _slicedToArray(_wp$element$useState7, 2),
    inputCompany = _wp$element$useState8[0],
    selectCompany = _wp$element$useState8[1];
  var issuerKey = 'mollie-payments-for-woocommerce_issuer_' + activePaymentMethod;
  var companyNameString = requiredFields.companyNameString,
    phoneString = requiredFields.phoneString;
  function getPhoneField() {
    var shippingPhone = document.getElementById('shipping-phone');
    var billingPhone = document.getElementById('billing-phone');
    return billingPhone || shippingPhone;
  }
  useEffect(function () {
    var onProcessingPayment = function onProcessingPayment() {
      var data = _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty({
        payment_method: activePaymentMethod,
        payment_method_title: item.title
      }, issuerKey, selectedIssuer), "billing_phone", inputPhone), "billing_company_billie", inputCompany), "billing_birthdate", inputBirthdate), "cardToken", '');
      var tokenVal = jQuery('.mollie-components > input').val();
      if (tokenVal) {
        data.cardToken = tokenVal;
      }
      return {
        type: responseTypes.SUCCESS,
        meta: {
          paymentMethodData: data
        }
      };
    };
    var unsubscribePaymentProcessing = onPaymentSetup(onProcessingPayment);
    return function () {
      unsubscribePaymentProcessing();
    };
  }, [selectedIssuer, onPaymentSetup, inputPhone, inputCompany, inputBirthdate]);
  useEffect(function () {
    var companyLabel = jQuery('div.wc-block-components-text-input.wc-block-components-address-form__company > label');
    if (companyLabel.length === 0 || item.hideCompanyField === true) {
      return;
    }
    if (activePaymentMethod === 'mollie_wc_gateway_billie') {
      var message = item.companyPlaceholder;
      companyLabel.replaceWith('<label htmlFor="shipping-company">' + message + '</label>');
    } else {
      if (companyNameString !== false) {
        companyLabel.replaceWith('<label htmlFor="shipping-company">' + companyNameString + '</label>');
      }
    }
    var isCompanyEmpty = billing.billingData.company === '' && shippingData.shippingAddress.company === '' && inputCompany === '';
    var unsubscribeProcessing = onCheckoutValidation(function () {
      if (activePaymentMethod === 'mollie_wc_gateway_billie' && isCompanyEmpty) {
        return {
          errorMessage: item.errorMessage
        };
      }
    });
    return function () {
      unsubscribeProcessing();
    };
  }, [activePaymentMethod, onCheckoutValidation, billing.billingData, item, companyNameString, inputCompany]);
  useEffect(function () {
    var _getPhoneField$labels, _getPhoneField;
    var phoneLabel = (_getPhoneField$labels = (_getPhoneField = getPhoneField()) === null || _getPhoneField === void 0 || (_getPhoneField = _getPhoneField.labels) === null || _getPhoneField === void 0 ? void 0 : _getPhoneField[0]) !== null && _getPhoneField$labels !== void 0 ? _getPhoneField$labels : null;
    if (!phoneLabel || phoneLabel.length === 0) {
      return;
    }
    if (activePaymentMethod === 'mollie_wc_gateway_in3') {
      phoneLabel.innerText = item.phonePlaceholder;
    } else {
      if (phoneString !== false) {
        phoneLabel.innerText = phoneString;
      }
    }
    var isPhoneEmpty = billing.billingData.phone === '' && shippingData.shippingAddress.phone === '' && inputPhone === '';
    var isBirthdateValid = inputBirthdate === '';
    var today = new Date();
    var birthdate = new Date(inputBirthdate);
    if (birthdate > today) {
      isBirthdateValid = false;
    }
    var unsubscribeProcessing = onCheckoutValidation(function () {
      if (activePaymentMethod === 'mollie_wc_gateway_in3' && (isPhoneEmpty || isBirthdateValid)) {
        return {
          errorMessage: item.errorMessage
        };
      }
    });
    return function () {
      unsubscribeProcessing();
    };
  }, [activePaymentMethod, onCheckoutValidation, billing.billingData, shippingData.shippingAddress, item, phoneString, inputBirthdate, inputPhone]);
  onSubmitLocal = onSubmit;
  var updateIssuer = function updateIssuer(e) {
    return selectIssuer(e.target.value);
  };
  var updateCompany = function updateCompany(e) {
    return selectCompany(e.target.value);
  };
  var updatePhone = function updatePhone(e) {
    return selectPhone(e.target.value);
  };
  var updateBirthdate = function updateBirthdate(e) {
    return selectBirthdate(e.target.value);
  };
  var itemContentP = item.content;
  if (item.content !== '') {
    itemContentP = /*#__PURE__*/React.createElement("p", null, item.content);
  }
  function fieldMarkup(id, fieldType, label, action, value) {
    var placeholder = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
    var className = "wc-block-components-text-input wc-block-components-address-form__" + id;
    return /*#__PURE__*/React.createElement("div", {
      class: "custom-input"
    }, /*#__PURE__*/React.createElement("label", {
      htmlFor: id,
      dangerouslySetInnerHTML: {
        __html: label
      }
    }), /*#__PURE__*/React.createElement("input", {
      type: fieldType,
      name: id,
      id: id,
      value: value,
      onChange: action,
      placeholder: placeholder
    }));
  }
  if (item.issuers && item.name !== "mollie_wc_gateway_creditcard") {
    return /*#__PURE__*/React.createElement("div", null, itemContentP, /*#__PURE__*/React.createElement("select", {
      name: issuerKey,
      dangerouslySetInnerHTML: {
        __html: item.issuers
      },
      value: selectedIssuer,
      onChange: updateIssuer
    }));
  }
  if (item.name === "mollie_wc_gateway_creditcard") {
    return /*#__PURE__*/React.createElement("div", {
      dangerouslySetInnerHTML: {
        __html: item.content
      }
    });
  }
  if (item.name === "mollie_wc_gateway_billie") {
    var billingCompanyField = document.querySelector('#billing-company');
    var shippingCompanyField = document.querySelector('#shipping-company');
    var isBillingCompanyRequired = billingCompanyField === null || billingCompanyField === void 0 ? void 0 : billingCompanyField.hasAttribute('required');
    var isShippingCompanyRequired = shippingCompanyField === null || shippingCompanyField === void 0 ? void 0 : shippingCompanyField.hasAttribute('required');
    if (billingCompanyField && isBillingCompanyRequired || shippingCompanyField && isShippingCompanyRequired || item.hideCompanyField === true) {
      return;
    }
    var companyField = item.companyPlaceholder ? item.companyPlaceholder : "Company name";
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", null, itemContentP), fieldMarkup("billing_company_billie", "text", companyField, updateCompany, inputCompany));
  }
  useEffect(function () {
    var countryCodes = {
      BE: '+32xxxxxxxxx',
      NL: '+316xxxxxxxx',
      DE: '+49xxxxxxxxx',
      AT: '+43xxxxxxxxx'
    };
    var country = billing.billingData.country;
    item.phonePlaceholder = countryCodes[country] || countryCodes['NL'];
  }, [billing.billingData.country]);
  if (item.name === "mollie_wc_gateway_in3") {
    var birthdateField = item.birthdatePlaceholder || "Birthdate";
    var phoneField = item.phonePlaceholder || "+316xxxxxxxx";
    var phoneLabel = item.phoneLabel || "Phone";
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", null, itemContentP), fieldMarkup("billing-birthdate", "date", birthdateField, updateBirthdate, inputBirthdate), !isPhoneFieldVisible && fieldMarkup("billing-phone-in3", "tel", phoneLabel, updatePhone, inputPhone, phoneField));
  }
  if (item.name === "mollie_wc_gateway_riverty") {
    var _birthdateField = item.birthdatePlaceholder || "Birthdate";
    var _phoneField = item.phonePlaceholder || "+316xxxxxxxx";
    var _phoneLabel = item.phoneLabel || "Phone";
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", null, itemContentP), fieldMarkup("billing-birthdate", "date", _birthdateField, updateBirthdate, inputBirthdate), !isPhoneFieldVisible && fieldMarkup("billing-phone-riverty", "tel", _phoneLabel, updatePhone, inputPhone, _phoneField));
  }
  return /*#__PURE__*/React.createElement("div", null, itemContentP);
};
var Label = function Label(_ref2) {
  var item = _ref2.item,
    filters = _ref2.filters,
    ajaxUrl = _ref2.ajaxUrl;
  var cartData = wp.data.useSelect(function (select) {
    return select('wc/store/cart').getCartData();
  }, []);
  var cartTotals = wp.data.useSelect(function (select) {
    return select('wc/store/cart').getCartTotals();
  }, []);
  var cartTotal = (cartTotals === null || cartTotals === void 0 ? void 0 : cartTotals.total_price) || 0;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    dangerouslySetInnerHTML: {
      __html: item.label
    }
  }), /*#__PURE__*/React.createElement(MollieGatewayUpdater, {
    billing: cartData.billingAddress,
    currencyCode: wcSettings.currency.code,
    filters: filters,
    ajaxUrl: ajaxUrl,
    cartTotal: cartTotal
  }));
};
var molliePaymentMethod = function molliePaymentMethod(useEffect, ajaxUrl, filters, gatewayData, availableGateways, item, jQuery, requiredFields, isCompanyFieldVisible, isPhoneFieldVisible) {
  if (item.name === "mollie_wc_gateway_creditcard") {
    document.addEventListener('mollie_components_ready_to_submit', function () {
      onSubmitLocal();
    });
  }
  function creditcardSelectedEvent() {
    if (item.name === "mollie_wc_gateway_creditcard") {
      document.documentElement.dispatchEvent(creditCardSelected);
    }
  }
  return {
    name: item.name,
    label: /*#__PURE__*/React.createElement(Label, {
      item: item,
      ajaxUrl: ajaxUrl,
      filters: filters
    }),
    content: /*#__PURE__*/React.createElement(MollieComponent, {
      item: item,
      useEffect: useEffect,
      ajaxUrl: ajaxUrl,
      jQuery: jQuery,
      requiredFields: requiredFields,
      isPhoneFieldVisible: isPhoneFieldVisible
    }),
    edit: /*#__PURE__*/React.createElement("div", null, item.edit),
    paymentMethodId: item.paymentMethodId,
    canMakePayment: function canMakePayment(_ref3) {
      var cartTotals = _ref3.cartTotals,
        billingData = _ref3.billingData;
      if (!_.isEmpty(item.allowedCountries) && !item.allowedCountries.includes(billingData.country)) {
        return false;
      }
      if (cartTotals <= 0) {
        return true;
      }
      var currencyCode = cartTotals === null || cartTotals === void 0 ? void 0 : cartTotals.currency_code;
      var country = billingData === null || billingData === void 0 ? void 0 : billingData.country;
      if (!country) {
        var _wcSettings2;
        country = (_wcSettings2 = wcSettings) === null || _wcSettings2 === void 0 ? void 0 : _wcSettings2.baseLocation.country;
      }
      var currentFilterKey = currencyCode + "-" + country;
      creditcardSelectedEvent();
      if (!cachedAvailableGateways.hasOwnProperty(currentFilterKey)) {
        cachedAvailableGateways = _objectSpread(_objectSpread({}, cachedAvailableGateways), availableGateways);
      }
      if (availableGateways.hasOwnProperty(currentFilterKey) && availableGateways[currentFilterKey].hasOwnProperty(item.name)) {
        return true;
      }
      if (cachedAvailableGateways.hasOwnProperty(currentFilterKey) && cachedAvailableGateways[currentFilterKey].hasOwnProperty(item.name)) {
        return true;
      }
      return false;
    },
    ariaLabel: item.ariaLabel,
    supports: {
      features: item.supports
    }
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (molliePaymentMethod);

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!******************************************!*\
  !*** ./resources/js/mollieBlockIndex.js ***!
  \******************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _blocks_molliePaymentMethod__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./blocks/molliePaymentMethod */ "./resources/js/blocks/molliePaymentMethod.js");
/* harmony import */ var _blocks_ApplePayButtonComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./blocks/ApplePayButtonComponent */ "./resources/js/blocks/ApplePayButtonComponent.js");
/* harmony import */ var _blocks_ApplePayButtonEditorComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./blocks/ApplePayButtonEditorComponent */ "./resources/js/blocks/ApplePayButtonEditorComponent.js");



(function (_ref) {
  var mollieBlockData = _ref.mollieBlockData,
    wc = _ref.wc,
    _ = _ref._,
    jQuery = _ref.jQuery;
  if (_.isEmpty(mollieBlockData)) {
    return;
  }
  var registerPaymentMethod = wc.wcBlocksRegistry.registerPaymentMethod;
  var defaultFields = wc.wcSettings.allSettings.defaultFields;
  var _mollieBlockData$gate = mollieBlockData.gatewayData,
    ajaxUrl = _mollieBlockData$gate.ajaxUrl,
    filters = _mollieBlockData$gate.filters,
    gatewayData = _mollieBlockData$gate.gatewayData,
    availableGateways = _mollieBlockData$gate.availableGateways;
  var useEffect = wp.element.useEffect;
  var isAppleSession = typeof window.ApplePaySession === "function";
  function getPhoneField() {
    var phoneFieldDataset = document.querySelector('[data-show-phone-field]');
    if (!phoneFieldDataset) {
      return true;
    }
    return phoneFieldDataset.dataset.showPhoneField !== "false";
  }
  var companyNameString = defaultFields.company.label;
  var isPhoneFieldVisible = getPhoneField();
  var phoneString = defaultFields.phone.label;
  var requiredFields = {
    'companyNameString': companyNameString,
    'phoneString': phoneString
  };
  gatewayData.forEach(function (item) {
    var register = function register() {
      return registerPaymentMethod((0,_blocks_molliePaymentMethod__WEBPACK_IMPORTED_MODULE_0__["default"])(useEffect, ajaxUrl, filters, gatewayData, availableGateways, item, jQuery, requiredFields, isPhoneFieldVisible));
    };
    if (item.name === 'mollie_wc_gateway_applepay') {
      var isExpressEnabled = item.isExpressEnabled;
      if (isAppleSession && window.ApplePaySession.canMakePayments()) {
        register();
        if (isExpressEnabled !== true) {
          return;
        }
        var registerExpressPaymentMethod = wc.wcBlocksRegistry.registerExpressPaymentMethod;
        registerExpressPaymentMethod({
          name: 'mollie_wc_gateway_applepay_express',
          title: 'Apple Pay Express button',
          description: 'Apple Pay Express button',
          content: /*#__PURE__*/React.createElement(_blocks_ApplePayButtonComponent__WEBPACK_IMPORTED_MODULE_1__["default"], null),
          edit: /*#__PURE__*/React.createElement(_blocks_ApplePayButtonEditorComponent__WEBPACK_IMPORTED_MODULE_2__["default"], null),
          ariaLabel: 'Apple Pay',
          canMakePayment: function canMakePayment() {
            return true;
          },
          paymentMethodId: 'mollie_wc_gateway_applepay',
          gatewayId: 'mollie_wc_gateway_applepay',
          supports: {
            features: ['products'],
            style: ['height', 'borderRadius']
          }
        });
      }
      return;
    }
    register();
  });
})(window, wc);
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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