/******/ (() => { // webpackBootstrap
/*!*******************************************!*\
  !*** ./resources/js/mollie-components.js ***!
  \*******************************************/
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
var SELECTOR_TOKEN_ELEMENT = '.cardToken';
var SELECTOR_MOLLIE_COMPONENTS_CONTAINER = '.mollie-components';
var SELECTOR_FORM = 'form';
var SELECTOR_MOLLIE_GATEWAY_CONTAINER = '.wc_payment_methods';
var SELECTOR_MOLLIE_NOTICE_CONTAINER = '#mollie-notice';
function returnFalse() {
  return false;
}
function returnTrue() {
  return true;
}

/* -------------------------------------------------------------------
   Containers
   ---------------------------------------------------------------- */
function gatewayContainer(container) {
  return container ? container.querySelector(SELECTOR_MOLLIE_GATEWAY_CONTAINER) : null;
}
function containerForGateway(gateway, container) {
  return container ? container.querySelector(".payment_method_mollie_wc_gateway_".concat(gateway)) : null;
}
function noticeContainer(container) {
  return container ? container.querySelector(SELECTOR_MOLLIE_NOTICE_CONTAINER) : null;
}
function componentsContainerFromWithin(container) {
  return container ? container.querySelector(SELECTOR_MOLLIE_COMPONENTS_CONTAINER) : null;
}
function cleanContainer(container) {
  if (!container) {
    return;
  }
  container.innerText = '';
}

/* -------------------------------------------------------------------
   Notice
   ---------------------------------------------------------------- */
function renderNotice(_ref) {
  var content = _ref.content,
    type = _ref.type;
  return "\n      <div id=\"mollie-notice\" class=\"woocommerce-".concat(type, "\">\n        ").concat(content, "\n      </div>\n    ");
}
function printNotice(jQuery, noticeData) {
  var container = gatewayContainer(document);
  var formContainer = closestFormForElement(container).parentNode || null;
  var mollieNotice = noticeContainer(document);
  var renderedNotice = renderNotice(noticeData);
  mollieNotice && mollieNotice.remove();
  if (!formContainer) {
    alert(noticeData.content);
    return;
  }
  formContainer.insertAdjacentHTML('beforebegin', renderedNotice);
  scrollToNotice(jQuery);
}
function scrollToNotice(jQuery) {
  var scrollToElement = noticeContainer(document);
  if (!scrollToElement) {
    scrollToElement = gatewayContainer(document);
  }
  jQuery.scroll_to_notices(jQuery(scrollToElement));
}

/* -------------------------------------------------------------------
   Token
   ---------------------------------------------------------------- */
function createTokenFieldWithin(container) {
  container.insertAdjacentHTML('beforeend', '<input type="hidden" name="cardToken" class="cardToken" value="" />');
}
function tokenElementWithin(container) {
  return container.querySelector(SELECTOR_TOKEN_ELEMENT);
}
function retrievePaymentToken(_x) {
  return _retrievePaymentToken.apply(this, arguments);
}
function _retrievePaymentToken() {
  _retrievePaymentToken = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(mollie) {
    var _yield$mollie$createT, token, error;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return mollie.createToken(SELECTOR_TOKEN_ELEMENT);
        case 2:
          _yield$mollie$createT = _context.sent;
          token = _yield$mollie$createT.token;
          error = _yield$mollie$createT.error;
          if (!error) {
            _context.next = 7;
            break;
          }
          throw new Error(error.message || '');
        case 7:
          return _context.abrupt("return", token);
        case 8:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return _retrievePaymentToken.apply(this, arguments);
}
function setTokenValueToField(token, tokenFieldElement) {
  if (!tokenFieldElement) {
    return;
  }
  tokenFieldElement.value = token;
  tokenFieldElement.setAttribute('value', token);
}

/* -------------------------------------------------------------------
   Form
   ---------------------------------------------------------------- */
function closestFormForElement(element) {
  return element ? element.closest(SELECTOR_FORM) : null;
}
function turnMollieComponentsSubmissionOff($form) {
  $form.off('checkout_place_order', returnFalse);
  $form.off('submit', submitForm);
}
function turnBlockListenerOff(target) {
  target.off('click', submitForm);
}
function isGatewaySelected(gateway) {
  var gatewayContainer = containerForGateway(gateway, document);
  var gatewayInput = gatewayContainer ? gatewayContainer.querySelector("#payment_method_mollie_wc_gateway_".concat(gateway)) : null;
  if (!gatewayInput) {
    return false;
  }
  return gatewayInput.checked || false;
}
function submitForm(_x2) {
  return _submitForm.apply(this, arguments);
}
/* -------------------------------------------------------------------
   Component
   ---------------------------------------------------------------- */
function _submitForm() {
  _submitForm = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(evt) {
    var token, _evt$data, jQuery, mollie, gateway, gatewayContainer, messages, form, $form, $document, _error, _error$message, content;
    return _regeneratorRuntime().wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          token = '';
          _evt$data = evt.data, jQuery = _evt$data.jQuery, mollie = _evt$data.mollie, gateway = _evt$data.gateway, gatewayContainer = _evt$data.gatewayContainer, messages = _evt$data.messages;
          form = closestFormForElement(gatewayContainer);
          $form = jQuery(form);
          $document = jQuery(document.body);
          if (isGatewaySelected(gateway)) {
            _context2.next = 9;
            break;
          }
          // Let other gateway to submit the form
          turnMollieComponentsSubmissionOff($form);
          $form.submit();
          return _context2.abrupt("return");
        case 9:
          evt.preventDefault();
          evt.stopImmediatePropagation();
          _context2.prev = 11;
          _context2.next = 14;
          return retrievePaymentToken(mollie);
        case 14:
          token = _context2.sent;
          _context2.next = 24;
          break;
        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](11);
          content = (_error = _context2.t0, _error$message = _error.message, message = _error$message === void 0 ? messages.defaultErrorMessage : _error$message, _error);
          content && printNotice(jQuery, {
            content: content,
            type: 'error'
          });
          $form.removeClass('processing').unblock();
          $document.trigger('checkout_error');
          return _context2.abrupt("return");
        case 24:
          turnMollieComponentsSubmissionOff($form);
          token && setTokenValueToField(token, tokenElementWithin(gatewayContainer));
          $form.submit();
        case 27:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[11, 17]]);
  }));
  return _submitForm.apply(this, arguments);
}
function componentElementByNameFromWithin(name, container) {
  return container ? container.querySelector(".mollie-component--".concat(name)) : null;
}
function createComponentLabelElementWithin(container, _ref2) {
  var label = _ref2.label;
  container.insertAdjacentHTML('beforebegin', "<b class=\"mollie-component-label\">".concat(label, "</b>"));
}
function createComponentsErrorContainerWithin(container, _ref3) {
  var name = _ref3.name;
  container.insertAdjacentHTML('afterend', "<div role=\"alert\" id=\"".concat(name, "-errors\"></div>"));
}
function componentByName(name, mollie, settings, mollieComponentsMap) {
  var component;
  if (mollieComponentsMap.has(name)) {
    component = mollieComponentsMap.get(name);
  }
  if (!component) {
    component = mollie.createComponent(name, settings);
  }
  return component;
}
function unmountComponents(mollieComponentsMap) {
  mollieComponentsMap.forEach(function (component) {
    return component.unmount();
  });
}
function mountComponent(mollie, componentSettings, componentAttributes, mollieComponentsMap, baseContainer) {
  var componentName = componentAttributes.name;
  var component = componentByName(componentName, mollie, componentSettings, mollieComponentsMap);
  var mollieComponentsContainer = componentsContainerFromWithin(baseContainer);
  mollieComponentsContainer.insertAdjacentHTML('beforeend', "<div id=\"".concat(componentName, "\"></div>"));
  component.mount("#".concat(componentName));
  var currentComponentElement = componentElementByNameFromWithin(componentName, baseContainer);
  if (!currentComponentElement) {
    console.warn("Component ".concat(componentName, " not found in the DOM. Probably had problem during mount."));
    return;
  }
  createComponentLabelElementWithin(currentComponentElement, componentAttributes);
  createComponentsErrorContainerWithin(currentComponentElement, componentAttributes);
  var componentError = document.querySelector('#' + componentName + '-errors');
  component.addEventListener('change', function (event) {
    if (event.error && event.touched) {
      componentError.textContent = event.error;
    } else {
      componentError.textContent = '';
    }
  });
  !mollieComponentsMap.has(componentName) && mollieComponentsMap.set(componentName, component);
}
function mountComponents(mollie, componentSettings, componentsAttributes, mollieComponentsMap, baseContainer) {
  componentsAttributes.forEach(function (componentAttributes) {
    return mountComponent(mollie, componentSettings, componentAttributes, mollieComponentsMap, baseContainer);
  });
}

/* -------------------------------------------------------------------
   Init
   ---------------------------------------------------------------- */

/**
 * Unmount and Mount the components if them already exists, create them if it's the first time
 * the components are created.
 */
function initializeComponents(jQuery, mollie, _ref4, mollieComponentsMap) {
  var options = _ref4.options,
    merchantProfileId = _ref4.merchantProfileId,
    componentsSettings = _ref4.componentsSettings,
    componentsAttributes = _ref4.componentsAttributes,
    enabledGateways = _ref4.enabledGateways,
    messages = _ref4.messages;
  /*
   * WooCommerce update the DOM when something on checkout page happen.
   * Mollie does not allow to keep a copy of the mounted components.
   *
   * We have to mount every time the components but we cannot recreate them.
   */
  unmountComponents(mollieComponentsMap);
  enabledGateways.forEach(function (gateway) {
    var gatewayContainer = containerForGateway(gateway, document);
    var mollieComponentsContainer = componentsContainerFromWithin(gatewayContainer);
    var form = closestFormForElement(gatewayContainer);
    var $form = jQuery(form);
    if (!gatewayContainer) {
      console.warn("Cannot initialize Mollie Components for gateway ".concat(gateway, "."));
      return;
    }
    if (!form) {
      console.warn('Cannot initialize Mollie Components, no form found.');
      return;
    }

    // Remove old listener before add new ones or form will not be submitted
    turnMollieComponentsSubmissionOff($form);

    /*
     * Clean container for mollie components because we do not know in which context we may need
     * to create components.
     */
    cleanContainer(mollieComponentsContainer);
    createTokenFieldWithin(mollieComponentsContainer);
    mountComponents(mollie, componentsSettings[gateway], componentsAttributes, mollieComponentsMap, gatewayContainer);
    $form.on('checkout_place_order', returnFalse);
    $form.on('submit', null, {
      jQuery: jQuery,
      mollie: mollie,
      gateway: gateway,
      gatewayContainer: gatewayContainer,
      messages: messages
    }, submitForm);
    //waiting for the blocks to load, this should receive an event to look for the button instead
    setTimeout(function () {
      submitButton = jQuery(".wc-block-components-checkout-place-order-button");
      jQuery(submitButton).click({
        jQuery: jQuery,
        mollie: mollie,
        gateway: gateway,
        gatewayContainer: gatewayContainer,
        messages: messages
      }, submitForm);
    }, 500);
  });
}
(function (_ref5) {
  var _ = _ref5._,
    Mollie = _ref5.Mollie,
    mollieComponentsSettings = _ref5.mollieComponentsSettings,
    jQuery = _ref5.jQuery;
  if (_.isEmpty(mollieComponentsSettings) || !_.isFunction(Mollie)) {
    return;
  }
  var eventName = 'updated_checkout';
  var mollieComponentsMap = new Map();
  var $document = jQuery(document);
  var merchantProfileId = mollieComponentsSettings.merchantProfileId,
    options = mollieComponentsSettings.options,
    isCheckoutPayPage = mollieComponentsSettings.isCheckoutPayPage;
  var mollie = new Mollie(merchantProfileId, options);
  if (isCheckoutPayPage) {
    eventName = 'payment_method_selected';
    $document.on(eventName, function () {
      return initializeComponents(jQuery, mollie, mollieComponentsSettings, mollieComponentsMap);
    });
    return;
  }
  function checkInit() {
    return function () {
      var copySettings = JSON.parse(JSON.stringify(mollieComponentsSettings));
      mollieComponentsSettings.enabledGateways.forEach(function (gateway, index) {
        var gatewayContainer = containerForGateway(gateway, document);
        if (!gatewayContainer) {
          copySettings.enabledGateways.splice(index, 1);
          var $form = jQuery('form[name="checkout"]');
          $form.on('checkout_place_order', returnTrue);
        }
      });
      if (_.isEmpty(copySettings.enabledGateways)) {
        return;
      }
      initializeComponents(jQuery, mollie, copySettings, mollieComponentsMap);
    };
  }
  $document.on(eventName, checkInit());
  $document.on('update_checkout', checkInit());
})(window);
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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