/******/ (() => { // webpackBootstrap
/*!**************************************************!*\
  !*** ./resources/js/mollie-components-blocks.js ***!
  \**************************************************/
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
var SELECTOR_TOKEN_ELEMENT = '.cardToken';
var SELECTOR_MOLLIE_COMPONENTS_CONTAINER = '.mollie-components';
var SELECTOR_FORM = 'form';
var SELECTOR_MOLLIE_GATEWAY_BLOCK_CONTAINER = '.wc-block-components-radio-control';
var SELECTOR_MOLLIE_NOTICE_CONTAINER = '#mollie-notice';
function returnFalse() {
  return false;
}
function returnTrue() {
  return true;
}

/* -------------------------------------------------------------------
   Containers
   ---------------------------------------------------------------- */
function gatewayContainer(container) {
  var blockContainer = container ? container.querySelector(SELECTOR_MOLLIE_GATEWAY_BLOCK_CONTAINER) : null;
  return blockContainer;
}
function containerForGateway(gateway, container) {
  return container ? container.querySelector(".payment_method_mollie_wc_gateway_".concat(gateway)) : null;
}
function noticeContainer(container) {
  return container ? container.querySelector(SELECTOR_MOLLIE_NOTICE_CONTAINER) : null;
}
function componentsContainerFromWithin(container) {
  return container ? container.querySelector(SELECTOR_MOLLIE_COMPONENTS_CONTAINER) : null;
}
function cleanContainer(container) {
  if (!container) {
    return;
  }
  container.innerText = '';
}

/* -------------------------------------------------------------------
   Notice
   ---------------------------------------------------------------- */
function renderNotice(_ref) {
  var content = _ref.content,
    type = _ref.type;
  return "\n      <div id=\"mollie-notice\" class=\"woocommerce-".concat(type, "\">\n        ").concat(content, "\n      </div>\n    ");
}
function printNotice(jQuery, noticeData) {
  var container = gatewayContainer(document);
  var formContainer = closestFormForElement(container).parentNode || null;
  var mollieNotice = noticeContainer(document);
  var renderedNotice = renderNotice(noticeData);
  mollieNotice && mollieNotice.remove();
  if (!formContainer) {
    alert(noticeData.content);
    return;
  }
  formContainer.insertAdjacentHTML('beforebegin', renderedNotice);
  scrollToNotice(jQuery);
}
function scrollToNotice(jQuery) {
  var scrollToElement = noticeContainer(document);
  if (!scrollToElement) {
    scrollToElement = gatewayContainer(document);
  }
  jQuery.scroll_to_notices(jQuery(scrollToElement));
}

/* -------------------------------------------------------------------
   Token
   ---------------------------------------------------------------- */
function createTokenFieldWithin(container) {
  container.insertAdjacentHTML('beforeend', '<input type="hidden" name="cardToken" class="cardToken" value="" />');
}
function tokenElementWithin(container) {
  return container.querySelector(SELECTOR_TOKEN_ELEMENT);
}
function retrievePaymentToken(_x) {
  return _retrievePaymentToken.apply(this, arguments);
}
function _retrievePaymentToken() {
  _retrievePaymentToken = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(mollie) {
    var _yield$mollie$createT, token, error;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return mollie.createToken(SELECTOR_TOKEN_ELEMENT);
        case 2:
          _yield$mollie$createT = _context.sent;
          token = _yield$mollie$createT.token;
          error = _yield$mollie$createT.error;
          if (!error) {
            _context.next = 7;
            break;
          }
          throw new Error(error.message || '');
        case 7:
          return _context.abrupt("return", token);
        case 8:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return _retrievePaymentToken.apply(this, arguments);
}
function setTokenValueToField(token, tokenFieldElement) {
  if (!tokenFieldElement) {
    return;
  }
  tokenFieldElement.value = token;
  tokenFieldElement.setAttribute('value', token);
}

/* -------------------------------------------------------------------
   Form
   ---------------------------------------------------------------- */
function closestFormForElement(element) {
  return element ? element.closest(SELECTOR_FORM) : null;
}
function turnMollieComponentsSubmissionOff($form) {
  $form.off('checkout_place_order', returnFalse);
  $form.off('submit', submitForm);
}
function turnBlockListenerOff(target) {
  target.off('click', submitForm);
}
function isGatewaySelected(gateway) {
  var gatewayBlockInput = document.getElementById("radio-control-wc-payment-method-options-mollie_wc_gateway_creditcard");
  if (gatewayBlockInput) {
    return gatewayBlockInput.checked || false;
  }
}
function submitForm(_x2) {
  return _submitForm.apply(this, arguments);
}
/* -------------------------------------------------------------------
   Component
   ---------------------------------------------------------------- */
function _submitForm() {
  _submitForm = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(evt) {
    var token, _evt$data, jQuery, mollie, gateway, gatewayContainer, messages, form, $form, $document, _error, _error$message, content, readyToSubmitBlock;
    return _regeneratorRuntime().wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          token = '';
          _evt$data = evt.data, jQuery = _evt$data.jQuery, mollie = _evt$data.mollie, gateway = _evt$data.gateway, gatewayContainer = _evt$data.gatewayContainer, messages = _evt$data.messages;
          form = closestFormForElement(gatewayContainer);
          $form = jQuery(form);
          $document = jQuery(document.body);
          if (isGatewaySelected(gateway)) {
            _context2.next = 9;
            break;
          }
          // Let other gateway to submit the form
          turnMollieComponentsSubmissionOff($form);
          $form.submit();
          return _context2.abrupt("return");
        case 9:
          evt.preventDefault();
          evt.stopImmediatePropagation();
          _context2.prev = 11;
          _context2.next = 14;
          return retrievePaymentToken(mollie);
        case 14:
          token = _context2.sent;
          _context2.next = 24;
          break;
        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](11);
          content = (_error = _context2.t0, _error$message = _error.message, message = _error$message === void 0 ? messages.defaultErrorMessage : _error$message, _error);
          content && printNotice(jQuery, {
            content: content,
            type: 'error'
          });
          $form.removeClass('processing').unblock();
          $document.trigger('checkout_error');
          return _context2.abrupt("return");
        case 24:
          turnMollieComponentsSubmissionOff($form);
          token && setTokenValueToField(token, tokenElementWithin(gatewayContainer));
          if (!(evt.type === 'click')) {
            _context2.next = 31;
            break;
          }
          turnBlockListenerOff(jQuery(evt.target));
          readyToSubmitBlock = new Event("mollie_components_ready_to_submit", {
            bubbles: true
          });
          document.documentElement.dispatchEvent(readyToSubmitBlock);
          return _context2.abrupt("return");
        case 31:
          $form.submit();
        case 32:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[11, 17]]);
  }));
  return _submitForm.apply(this, arguments);
}
function componentElementByNameFromWithin(name, container) {
  return container ? container.querySelector(".mollie-component--".concat(name)) : null;
}
function createComponentLabelElementWithin(container, _ref2) {
  var label = _ref2.label;
  container.insertAdjacentHTML('beforebegin', "<b class=\"mollie-component-label\">".concat(label, "</b>"));
}
function createComponentsErrorContainerWithin(container, _ref3) {
  var name = _ref3.name;
  container.insertAdjacentHTML('afterend', "<div role=\"alert\" id=\"".concat(name, "-errors\"></div>"));
}
function componentByName(name, mollie, settings, mollieComponentsMap) {
  var component;
  if (mollieComponentsMap.has(name)) {
    component = mollieComponentsMap.get(name);
  }
  if (!component) {
    component = mollie.createComponent(name, settings);
  }
  return component;
}
function unmountComponents(mollieComponentsMap) {
  mollieComponentsMap.forEach(function (component) {
    try {
      component.unmount();
    } catch (err) {}
  });
}
function mountComponent(mollie, componentSettings, componentAttributes, mollieComponentsMap, baseContainer) {
  var componentName = componentAttributes.name;
  var component = componentByName(componentName, mollie, componentSettings, mollieComponentsMap);
  var mollieComponentsContainer = componentsContainerFromWithin(baseContainer);
  mollieComponentsContainer.insertAdjacentHTML('beforeend', "<div id=\"".concat(componentName, "\"></div>"));
  component.mount("#".concat(componentName));
  var currentComponentElement = componentElementByNameFromWithin(componentName, baseContainer);
  if (!currentComponentElement) {
    console.warn("Component ".concat(componentName, " not found in the DOM. Probably had problem during mount."));
    return;
  }
  createComponentLabelElementWithin(currentComponentElement, componentAttributes);
  createComponentsErrorContainerWithin(currentComponentElement, componentAttributes);
  var componentError = document.querySelector('#' + componentName + '-errors');
  component.addEventListener('change', function (event) {
    if (event.error && event.touched) {
      componentError.textContent = event.error;
    } else {
      componentError.textContent = '';
    }
  });
  !mollieComponentsMap.has(componentName) && mollieComponentsMap.set(componentName, component);
}
function mountComponents(mollie, componentSettings, componentsAttributes, mollieComponentsMap, baseContainer) {
  componentsAttributes.forEach(function (componentAttributes) {
    try {
      mountComponent(mollie, componentSettings, componentAttributes, mollieComponentsMap, baseContainer);
    } catch (err) {}
  });
}

/* -------------------------------------------------------------------
   Init
   ---------------------------------------------------------------- */

/**
 * Unmount and Mount the components if them already exists, create them if it's the first time
 * the components are created.
 */
function initializeComponents(jQuery, mollie, _ref4, mollieComponentsMap) {
  var options = _ref4.options,
    merchantProfileId = _ref4.merchantProfileId,
    componentsSettings = _ref4.componentsSettings,
    componentsAttributes = _ref4.componentsAttributes,
    enabledGateways = _ref4.enabledGateways,
    messages = _ref4.messages;
  /*
   * WooCommerce update the DOM when something on checkout page happen.
   * Mollie does not allow to keep a copy of the mounted components.
   *
   * We have to mount every time the components but we cannot recreate them.
   */
  unmountComponents(mollieComponentsMap);
  enabledGateways.forEach(function (gateway) {
    var gatewayContainer = containerForGateway(gateway, document);
    var mollieComponentsContainer = componentsContainerFromWithin(gatewayContainer);
    var form = closestFormForElement(gatewayContainer);
    var $form = jQuery(form);
    if (!gatewayContainer) {
      console.warn("Cannot initialize Mollie Components for gateway ".concat(gateway, "."));
      return;
    }
    if (!form) {
      console.warn('Cannot initialize Mollie Components, no form found.');
      return;
    }

    // Remove old listener before add new ones or form will not be submitted
    turnMollieComponentsSubmissionOff($form);

    /*
     * Clean container for mollie components because we do not know in which context we may need
     * to create components.
     */
    if (!mollieComponentsContainer) {
      return;
    }
    cleanContainer(mollieComponentsContainer);
    createTokenFieldWithin(mollieComponentsContainer);
    mountComponents(mollie, componentsSettings[gateway], componentsAttributes, mollieComponentsMap, gatewayContainer);
    $form.on('checkout_place_order', returnFalse);
    $form.on('submit', null, {
      jQuery: jQuery,
      mollie: mollie,
      gateway: gateway,
      gatewayContainer: gatewayContainer,
      messages: messages
    }, submitForm);
    //waiting for the blocks to load, this should receive an event to look for the button instead
    setTimeout(function () {
      submitButton = jQuery(".wc-block-components-checkout-place-order-button");
      jQuery(submitButton).click({
        jQuery: jQuery,
        mollie: mollie,
        gateway: gateway,
        gatewayContainer: gatewayContainer,
        messages: messages
      }, submitForm);
    }, 500);
  });
}
(function (_ref5) {
  var _ = _ref5._,
    Mollie = _ref5.Mollie,
    mollieComponentsSettings = _ref5.mollieComponentsSettings,
    jQuery = _ref5.jQuery;
  if (_.isEmpty(mollieComponentsSettings) || !_.isFunction(Mollie)) {
    return;
  }
  try {
    var checkInit = function checkInit() {
      return function () {
        var copySettings = JSON.parse(JSON.stringify(mollieComponentsSettings));
        mollieComponentsSettings.enabledGateways.forEach(function (gateway, index) {
          var gatewayContainer = containerForGateway(gateway, document);
          if (!gatewayContainer) {
            copySettings.enabledGateways.splice(index, 1);
            var $form = jQuery('form[name="checkout"]');
            $form.on('checkout_place_order', returnTrue);
          }
        });
        if (_.isEmpty(copySettings.enabledGateways)) {
          return;
        }
        initializeComponents(jQuery, mollie, copySettings, mollieComponentsMap);
      };
    };
    var eventName = 'updated_checkout';
    var mollieComponentsMap = new Map();
    var $document = jQuery(document);
    var merchantProfileId = mollieComponentsSettings.merchantProfileId,
      options = mollieComponentsSettings.options,
      isCheckoutPayPage = mollieComponentsSettings.isCheckoutPayPage;
    var mollie = new Mollie(merchantProfileId, options);
    if (isCheckoutPayPage) {
      eventName = 'payment_method_selected';
      $document.on(eventName, function () {
        return initializeComponents(jQuery, mollie, mollieComponentsSettings, mollieComponentsMap);
      });
      return;
    }
    document.addEventListener("mollie_creditcard_component_selected", function (event) {
      setTimeout(function () {
        initializeComponents(jQuery, mollie, mollieComponentsSettings, mollieComponentsMap);
      }, 500);
    });
    $document.on(eventName, checkInit());
    $document.on('update_checkout', checkInit());
  } catch (err) {}
})(window);
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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