/******/ (() => { // webpackBootstrap
/*!******************************************!*\
  !*** ./resources/js/gatewaySurcharge.js ***!
  \******************************************/
(function (_ref) {
  var jQuery = _ref.jQuery,
    surchargeData = _ref.surchargeData;
  jQuery(function ($) {
    $('body').on('change', 'input[name="payment_method"]', function () {
      $('body').trigger('update_checkout');
    });
  });
  if (!surchargeData) {
    return;
  }
  var isOrderPay = document.body.classList.contains('woocommerce-order-pay');
  if (isOrderPay) {
    jQuery(function ($) {
      var orderId = false;
      var hiddenField = $('input:hidden[name="mollie-woocommerce-orderId"]');
      if (hiddenField.length) {
        orderId = hiddenField.val();
      }
      var gatewayLabel = surchargeData.gatewayFeeLabel;
      var updateSurcharge = function updateSurcharge() {
        jQuery.ajax({
          url: surchargeData.ajaxUrl,
          method: 'POST',
          data: {
            action: 'update_surcharge_order_pay',
            method: $('input:radio[name="payment_method"]:checked').val(),
            orderId: orderId,
            nonce: $('input[name="mollie-surcharge-nonce"]').val()
          },
          success: function success(response) {
            var result = response.data;
            if (result) {
              var productTotal = "</th><td class='product-total'><span class='woocommerce-Price-amount amount'><bdi><span class='woocommerce-Price-currencySymbol'>" + result.currency + "</span>" + result.newTotal + "</bdi></span></td>";
              if (!result.amount) {
                if ($('#order_review table:first-child tfoot tr').text().indexOf(gatewayLabel) !== -1) {
                  $('#order_review table:first-child tfoot tr:contains("' + gatewayLabel + '")').remove();
                  $('#order_review table:first-child tfoot tr:last td').replaceWith(productTotal);
                }
              } else {
                var tableRow = "<tr><th scope='row' colspan='2'>" + result.name + "</th><td class='product-total'><span class='woocommerce-Price-amount amount'><bdi><span class='woocommerce-Price-currencySymbol'>" + result.currency + "</span>" + result.amount.toFixed(2) + "</bdi></span></td></tr>";
                if ($('#order_review table:first-child tfoot tr').text().indexOf(gatewayLabel) !== -1) {
                  $('#order_review table:first-child tfoot tr:contains("' + gatewayLabel + '")').replaceWith(tableRow);
                  $('#order_review table:first-child tfoot tr:last td').replaceWith(productTotal);
                } else {
                  $('#order_review table:first-child tfoot tr:first').after(tableRow);
                  $('#order_review table:first-child tfoot tr:last td').replaceWith(productTotal);
                }
              }
            }
          },
          error: function error(jqXHR, textStatus, errorThrown) {
            console.warn(textStatus, errorThrown);
          }
        });
      };
      updateSurcharge();
      $('body').on('change', 'input[name="payment_method"]', function () {
        updateSurcharge();
      });
    });
  }
})(window);
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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