/******/ (() => { // webpackBootstrap
/*!*****************************************!*\
  !*** ./resources/js/gatewaySettings.js ***!
  \*****************************************/
(function (_ref) {
  var _ = _ref._,
    gatewaySettingsData = _ref.gatewaySettingsData,
    jQuery = _ref.jQuery;
  var isEnabledIcon = gatewaySettingsData.isEnabledIcon,
    uploadFieldName = gatewaySettingsData.uploadFieldName,
    enableFieldName = gatewaySettingsData.enableFieldName,
    iconUrl = gatewaySettingsData.iconUrl,
    message = gatewaySettingsData.message,
    pluginUrlImages = gatewaySettingsData.pluginUrlImages;
  if (_.isEmpty(gatewaySettingsData)) {
    return;
  }
  document.addEventListener("DOMContentLoaded", function (event) {
    if (!isEnabledIcon) {
      return;
    }
    var uploadField = document.querySelector('#' + uploadFieldName);
    if (_.isEmpty(iconUrl)) {
      uploadField.insertAdjacentHTML('afterend', '<div class="mollie_custom_icon"><p>' + message + '</p></div>');
    } else {
      uploadField.insertAdjacentHTML('afterend', '<div class="mollie_custom_icon"><img src="' + iconUrl + '" alt="custom icon image" width="100px"></div>');
    }
  });
  function iconName(val) {
    var res = val.split("-");
    return res[0] + "/" + res[1] + "/" + res[2] + "-" + res[3];
  }
  jQuery(function ($) {
    $('#' + enableFieldName).change(function () {
      if ($(this).is(':checked')) {
        $('#' + uploadFieldName).closest('tr').show();
      } else {
        $('#' + uploadFieldName).closest('tr').hide();
      }
    }).change();
    var payPalIconSelectorElement = $('#mollie_wc_gateway_paypal_color');
    payPalIconSelectorElement.change(function () {
      var fixedPath = pluginUrlImages + "/PayPal_Buttons/";
      var buttonIcon = iconName(payPalIconSelectorElement.val()) + ".png";
      var url = fixedPath + buttonIcon;
      var iconImageElement = $('#mol-paypal-settings-icon');
      if (iconImageElement.length) {
        iconImageElement.remove();
      }
      payPalIconSelectorElement.after("<img id='mol-paypal-settings-icon' width='200px' src=" + url + " alt='PayPal_Icon'/>");
    }).change();
  });
})(window);
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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