/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/js/applePayError.js":
/*!***************************************!*\
  !*** ./resources/js/applePayError.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createAppleErrors: () => (/* binding */ createAppleErrors)
/* harmony export */ });
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function createAppleErrors(errors) {
  var errorList = [];
  var _iterator = _createForOfIteratorHelper(errors),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var error = _step.value;
      var _error$contactField = error.contactField,
        contactField = _error$contactField === void 0 ? null : _error$contactField,
        _error$code = error.code,
        code = _error$code === void 0 ? null : _error$code,
        _error$message = error.message,
        message = _error$message === void 0 ? null : _error$message;
      var appleError = contactField ? new ApplePayError(code, contactField, message) : new ApplePayError(code);
      errorList.push(appleError);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return errorList;
}

/***/ }),

/***/ "./resources/js/applePayRequest.js":
/*!*****************************************!*\
  !*** ./resources/js/applePayRequest.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   request: () => (/* binding */ request)
/* harmony export */ });
var request = function request(countryCode, currencyCode, totalLabel, subtotal) {
  return {
    countryCode: countryCode,
    currencyCode: currencyCode,
    supportedNetworks: ['amex', 'maestro', 'masterCard', 'visa', 'vPay'],
    merchantCapabilities: ['supports3DS'],
    shippingType: 'shipping',
    requiredBillingContactFields: ['postalAddress', 'email'],
    requiredShippingContactFields: ['postalAddress', 'email'],
    total: {
      label: totalLabel,
      amount: subtotal,
      type: 'final'
    }
  };
};

/***/ }),

/***/ "./resources/js/maybeShowApplePayButton.js":
/*!*************************************************!*\
  !*** ./resources/js/maybeShowApplePayButton.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   maybeShowButton: () => (/* binding */ maybeShowButton)
/* harmony export */ });
var maybeShowButton = function maybeShowButton() {
  var _window = window,
    ApplePaySession = _window.ApplePaySession;
  var applePayMethodElement = document.querySelector('#mollie-applepayDirect-button');
  var canShowButton = applePayMethodElement && ApplePaySession && ApplePaySession.canMakePayments();
  if (!canShowButton) {
    return false;
  }
  var button = document.createElement('button');
  button.setAttribute('id', 'mollie_applepay_button');
  button.classList.add('apple-pay-button');
  button.classList.add('apple-pay-button-black');
  applePayMethodElement.appendChild(button);
  return true;
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!********************************************!*\
  !*** ./resources/js/applepayDirectCart.js ***!
  \********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _applePayError_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./applePayError.js */ "./resources/js/applePayError.js");
/* harmony import */ var _applePayRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./applePayRequest */ "./resources/js/applePayRequest.js");
/* harmony import */ var _maybeShowApplePayButton_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./maybeShowApplePayButton.js */ "./resources/js/maybeShowApplePayButton.js");



(function (_ref) {
  var _ = _ref._,
    mollieApplePayDirectDataCart = _ref.mollieApplePayDirectDataCart,
    jQuery = _ref.jQuery;
  if (_.isEmpty(mollieApplePayDirectDataCart)) {
    return;
  }
  var _mollieApplePayDirect = mollieApplePayDirectDataCart.product,
    _mollieApplePayDirect2 = _mollieApplePayDirect.needShipping,
    needShipping = _mollieApplePayDirect2 === void 0 ? true : _mollieApplePayDirect2,
    subtotal = _mollieApplePayDirect.subtotal,
    _mollieApplePayDirect3 = mollieApplePayDirectDataCart.shop,
    countryCode = _mollieApplePayDirect3.countryCode,
    _mollieApplePayDirect4 = _mollieApplePayDirect3.currencyCode,
    currencyCode = _mollieApplePayDirect4 === void 0 ? 'EUR' : _mollieApplePayDirect4,
    _mollieApplePayDirect5 = _mollieApplePayDirect3.totalLabel,
    totalLabel = _mollieApplePayDirect5 === void 0 ? '' : _mollieApplePayDirect5,
    ajaxUrl = mollieApplePayDirectDataCart.ajaxUrl;
  if (!subtotal || !countryCode || !ajaxUrl) {
    return;
  }
  var nonce = document.getElementById("woocommerce-process-checkout-nonce").value;
  var updatedContactInfo = [];
  var selectedShippingMethod = [];
  var redirectionUrl = '';
  var applePaySession = function applePaySession() {
    var session = new ApplePaySession(3, (0,_applePayRequest__WEBPACK_IMPORTED_MODULE_1__.request)(countryCode, currencyCode, totalLabel, Math.round(subtotal)));
    session.begin();
    session.onshippingmethodselected = function (event) {
      var _this = this;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_update_shipping_method',
          shippingMethod: event.shippingMethod,
          callerPage: 'cart',
          simplifiedContact: updatedContactInfo,
          'woocommerce-process-checkout-nonce': nonce
        },
        complete: function complete(jqXHR, textStatus) {},
        success: function success(applePayShippingMethodUpdate, textStatus, jqXHR) {
          var response = applePayShippingMethodUpdate.data;
          selectedShippingMethod = event.shippingMethod;
          if (applePayShippingMethodUpdate.success === false) {
            response.errors = (0,_applePayError_js__WEBPACK_IMPORTED_MODULE_0__.createAppleErrors)(response.errors);
          }
          _this.completeShippingMethodSelection(response);
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onshippingcontactselected = function (event) {
      var _this2 = this;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_update_shipping_contact',
          simplifiedContact: event.shippingContact,
          callerPage: 'cart',
          needShipping: needShipping,
          'woocommerce-process-checkout-nonce': nonce
        },
        complete: function complete(jqXHR, textStatus) {},
        success: function success(applePayShippingContactUpdate, textStatus, jqXHR) {
          var response = applePayShippingContactUpdate.data;
          updatedContactInfo = event.shippingContact;
          if (applePayShippingContactUpdate.success === false) {
            response.errors = (0,_applePayError_js__WEBPACK_IMPORTED_MODULE_0__.createAppleErrors)(response.errors);
          }
          if (response.newShippingMethods) {
            selectedShippingMethod = response.newShippingMethods[0];
          }
          _this2.completeShippingContactSelection(response);
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onvalidatemerchant = function (applePayValidateMerchantEvent) {
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_validation',
          validationUrl: applePayValidateMerchantEvent.validationURL,
          'woocommerce-process-checkout-nonce': nonce
        },
        complete: function complete(jqXHR, textStatus) {},
        success: function success(merchantSession, textStatus, jqXHR) {
          if (merchantSession.success === true) {
            session.completeMerchantValidation(JSON.parse(merchantSession.data));
          } else {
            console.warn(merchantSession.data);
            session.abort();
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onpaymentauthorized = function (ApplePayPayment) {
      var _ApplePayPayment$paym = ApplePayPayment.payment,
        billingContact = _ApplePayPayment$paym.billingContact,
        shippingContact = _ApplePayPayment$paym.shippingContact;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_create_order_cart',
          shippingContact: ApplePayPayment.payment.shippingContact,
          billingContact: ApplePayPayment.payment.billingContact,
          token: ApplePayPayment.payment.token,
          shippingMethod: selectedShippingMethod,
          'mollie-payments-for-woocommerce_issuer_applepay': 'applepay',
          'woocommerce-process-checkout-nonce': nonce,
          'billing_first_name': billingContact.givenName || '',
          'billing_last_name': billingContact.familyName || '',
          'billing_company': '',
          'billing_country': billingContact.countryCode || '',
          'billing_address_1': billingContact.addressLines[0] || '',
          'billing_address_2': billingContact.addressLines[1] || '',
          'billing_postcode': billingContact.postalCode || '',
          'billing_city': billingContact.locality || '',
          'billing_state': billingContact.administrativeArea || '',
          'billing_phone': billingContact.phoneNumber || '000000000000',
          'billing_email': shippingContact.emailAddress || '',
          'shipping_first_name': shippingContact.givenName || '',
          'shipping_last_name': shippingContact.familyName || '',
          'shipping_company': '',
          'shipping_country': shippingContact.countryCode || '',
          'shipping_address_1': shippingContact.addressLines[0] || '',
          'shipping_address_2': shippingContact.addressLines[1] || '',
          'shipping_postcode': shippingContact.postalCode || '',
          'shipping_city': shippingContact.locality || '',
          'shipping_state': shippingContact.administrativeArea || '',
          'shipping_phone': shippingContact.phoneNumber || '000000000000',
          'shipping_email': shippingContact.emailAddress || '',
          'order_comments': '',
          'payment_method': 'mollie_wc_gateway_applepay',
          '_wp_http_referer': '/?wc-ajax=update_order_review'
        },
        complete: function complete(jqXHR, textStatus) {},
        success: function success(authorizationResult, textStatus, jqXHR) {
          var result = authorizationResult.data;
          if (authorizationResult.success === true) {
            redirectionUrl = result['returnUrl'];
            session.completePayment(result['responseToApple']);
            window.location.href = redirectionUrl;
          } else {
            result.errors = (0,_applePayError_js__WEBPACK_IMPORTED_MODULE_0__.createAppleErrors)(result.errors);
            session.completePayment(result);
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
  };
  if (!(0,_maybeShowApplePayButton_js__WEBPACK_IMPORTED_MODULE_2__.maybeShowButton)()) {
    return;
  }
  jQuery(document.body).on('updated_cart_totals', function (event) {
    (0,_maybeShowApplePayButton_js__WEBPACK_IMPORTED_MODULE_2__.maybeShowButton)();
    document.querySelector('#mollie_applepay_button').addEventListener('click', function (evt) {
      evt.preventDefault();
      applePaySession();
    });
  });
  document.querySelector('#mollie_applepay_button').addEventListener('click', function (evt) {
    evt.preventDefault();
    applePaySession();
  });
})(window);
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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