/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/js/applePayError.js":
/*!***************************************!*\
  !*** ./resources/js/applePayError.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createAppleErrors: () => (/* binding */ createAppleErrors)
/* harmony export */ });
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function createAppleErrors(errors) {
  var errorList = [];
  var _iterator = _createForOfIteratorHelper(errors),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var error = _step.value;
      var _error$contactField = error.contactField,
        contactField = _error$contactField === void 0 ? null : _error$contactField,
        _error$code = error.code,
        code = _error$code === void 0 ? null : _error$code,
        _error$message = error.message,
        message = _error$message === void 0 ? null : _error$message;
      var appleError = contactField ? new ApplePayError(code, contactField, message) : new ApplePayError(code);
      errorList.push(appleError);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return errorList;
}

/***/ }),

/***/ "./resources/js/applePayRequest.js":
/*!*****************************************!*\
  !*** ./resources/js/applePayRequest.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   request: () => (/* binding */ request)
/* harmony export */ });
var request = function request(countryCode, currencyCode, totalLabel, subtotal) {
  return {
    countryCode: countryCode,
    currencyCode: currencyCode,
    supportedNetworks: ['amex', 'maestro', 'masterCard', 'visa', 'vPay'],
    merchantCapabilities: ['supports3DS'],
    shippingType: 'shipping',
    requiredBillingContactFields: ['postalAddress', 'email'],
    requiredShippingContactFields: ['postalAddress', 'email'],
    total: {
      label: totalLabel,
      amount: subtotal,
      type: 'final'
    }
  };
};

/***/ }),

/***/ "./resources/js/maybeShowApplePayButton.js":
/*!*************************************************!*\
  !*** ./resources/js/maybeShowApplePayButton.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   maybeShowButton: () => (/* binding */ maybeShowButton)
/* harmony export */ });
var maybeShowButton = function maybeShowButton() {
  var _window = window,
    ApplePaySession = _window.ApplePaySession;
  var applePayMethodElement = document.querySelector('#mollie-applepayDirect-button');
  var canShowButton = applePayMethodElement && ApplePaySession && ApplePaySession.canMakePayments();
  if (!canShowButton) {
    return false;
  }
  var button = document.createElement('button');
  button.setAttribute('id', 'mollie_applepay_button');
  button.classList.add('apple-pay-button');
  button.classList.add('apple-pay-button-black');
  applePayMethodElement.appendChild(button);
  return true;
};

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!****************************************!*\
  !*** ./resources/js/applepayDirect.js ***!
  \****************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _applePayError_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./applePayError.js */ "./resources/js/applePayError.js");
/* harmony import */ var _maybeShowApplePayButton_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./maybeShowApplePayButton.js */ "./resources/js/maybeShowApplePayButton.js");
/* harmony import */ var _applePayRequest_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./applePayRequest.js */ "./resources/js/applePayRequest.js");



(function (_ref) {
  var _ = _ref._,
    mollieApplePayDirectData = _ref.mollieApplePayDirectData,
    jQuery = _ref.jQuery;
  if (_.isEmpty(mollieApplePayDirectData)) {
    return;
  }
  var _mollieApplePayDirect = mollieApplePayDirectData.product,
    id = _mollieApplePayDirect.id,
    _mollieApplePayDirect2 = _mollieApplePayDirect.needShipping,
    needShipping = _mollieApplePayDirect2 === void 0 ? true : _mollieApplePayDirect2,
    _mollieApplePayDirect3 = _mollieApplePayDirect.isVariation,
    isVariation = _mollieApplePayDirect3 === void 0 ? false : _mollieApplePayDirect3,
    price = _mollieApplePayDirect.price,
    stock = _mollieApplePayDirect.stock,
    _mollieApplePayDirect4 = mollieApplePayDirectData.shop,
    countryCode = _mollieApplePayDirect4.countryCode,
    _mollieApplePayDirect5 = _mollieApplePayDirect4.currencyCode,
    currencyCode = _mollieApplePayDirect5 === void 0 ? 'EUR' : _mollieApplePayDirect5,
    _mollieApplePayDirect6 = _mollieApplePayDirect4.totalLabel,
    totalLabel = _mollieApplePayDirect6 === void 0 ? '' : _mollieApplePayDirect6,
    ajaxUrl = mollieApplePayDirectData.ajaxUrl;
  if (!id || !price || !countryCode || !ajaxUrl) {
    return;
  }
  var outOfStock = stock === 'outofstock';
  if (outOfStock || !(0,_maybeShowApplePayButton_js__WEBPACK_IMPORTED_MODULE_1__.maybeShowButton)()) {
    return;
  }
  var nonce = document.getElementById('woocommerce-process-checkout-nonce').value;
  var productId = id;
  var productQuantity = 1;
  var updatedContactInfo = [];
  var selectedShippingMethod = [];
  var redirectionUrl = '';
  document.querySelector('input.qty').addEventListener('change', function (event) {
    productQuantity = event.currentTarget.value;
  });
  function disableButton(appleButton) {
    appleButton.disabled = true;
    appleButton.classList.add("buttonDisabled");
  }
  function enableButton(appleButton) {
    appleButton.disabled = false;
    appleButton.classList.remove("buttonDisabled");
  }
  if (isVariation) {
    var appleButton = document.querySelector('#mollie_applepay_button');
    jQuery('.single_variation_wrap').on('hide_variation', function (event, variation) {
      disableButton(appleButton);
      return;
    });
    jQuery('.single_variation_wrap').on('show_variation', function (event, variation) {
      // Fired when the user selects all the required dropdowns / attributes
      // and a final variation is selected / shown
      if (!variation.is_in_stock) {
        disableButton(appleButton);
        return;
      }
      if (variation.variation_id) {
        productId = variation.variation_id;
      }
      enableButton(appleButton);
    });
    disableButton(appleButton);
  }
  var amountWithoutTax = productQuantity * price;
  var applePaySession = function applePaySession() {
    var session = new ApplePaySession(3, (0,_applePayRequest_js__WEBPACK_IMPORTED_MODULE_2__.request)(countryCode, currencyCode, totalLabel, amountWithoutTax));
    session.begin();
    if (needShipping) {
      session.onshippingmethodselected = function (event) {
        var _this = this;
        jQuery.ajax({
          url: ajaxUrl,
          method: 'POST',
          data: {
            action: 'mollie_apple_pay_update_shipping_method',
            shippingMethod: event.shippingMethod,
            productId: productId,
            callerPage: 'productDetail',
            productQuantity: productQuantity,
            simplifiedContact: updatedContactInfo,
            'woocommerce-process-checkout-nonce': nonce
          },
          complete: function complete(jqXHR, textStatus) {},
          success: function success(applePayShippingMethodUpdate, textStatus, jqXHR) {
            var response = applePayShippingMethodUpdate.data;
            selectedShippingMethod = event.shippingMethod;
            if (applePayShippingMethodUpdate.success === false) {
              response.errors = (0,_applePayError_js__WEBPACK_IMPORTED_MODULE_0__.createAppleErrors)(response.errors);
            }
            _this.completeShippingMethodSelection(response);
          },
          error: function error(jqXHR, textStatus, errorThrown) {
            console.warn(textStatus, errorThrown);
            session.abort();
          }
        });
      };
      session.onshippingcontactselected = function (event) {
        var _this2 = this;
        jQuery.ajax({
          url: ajaxUrl,
          method: 'POST',
          data: {
            action: 'mollie_apple_pay_update_shipping_contact',
            productId: productId,
            callerPage: 'productDetail',
            productQuantity: productQuantity,
            simplifiedContact: event.shippingContact,
            needShipping: needShipping,
            'woocommerce-process-checkout-nonce': nonce
          },
          complete: function complete(jqXHR, textStatus) {},
          success: function success(applePayShippingContactUpdate, textStatus, jqXHR) {
            var response = applePayShippingContactUpdate.data;
            updatedContactInfo = event.shippingContact;
            if (applePayShippingContactUpdate.success === false) {
              response.errors = (0,_applePayError_js__WEBPACK_IMPORTED_MODULE_0__.createAppleErrors)(response.errors);
            }
            if (response.newShippingMethods) {
              selectedShippingMethod = response.newShippingMethods[0];
            }
            _this2.completeShippingContactSelection(response);
          },
          error: function error(jqXHR, textStatus, errorThrown) {
            console.warn(textStatus, errorThrown);
            session.abort();
          }
        });
      };
    }
    session.onvalidatemerchant = function (applePayValidateMerchantEvent) {
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_validation',
          validationUrl: applePayValidateMerchantEvent.validationURL,
          'woocommerce-process-checkout-nonce': nonce
        },
        complete: function complete(jqXHR, textStatus) {},
        success: function success(merchantSession, textStatus, jqXHR) {
          if (merchantSession.success === true) {
            session.completeMerchantValidation(JSON.parse(merchantSession.data));
          } else {
            console.warn(merchantSession.data);
            session.abort();
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onpaymentauthorized = function (ApplePayPayment) {
      var _ApplePayPayment$paym = ApplePayPayment.payment,
        billingContact = _ApplePayPayment$paym.billingContact,
        shippingContact = _ApplePayPayment$paym.shippingContact;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_create_order',
          productId: productId,
          productQuantity: productQuantity,
          shippingContact: ApplePayPayment.payment.shippingContact,
          billingContact: ApplePayPayment.payment.billingContact,
          token: ApplePayPayment.payment.token,
          shippingMethod: selectedShippingMethod,
          'mollie-payments-for-woocommerce_issuer_applepay': 'applepay',
          'woocommerce-process-checkout-nonce': nonce,
          'billing_first_name': billingContact.givenName || '',
          'billing_last_name': billingContact.familyName || '',
          'billing_company': '',
          'billing_country': billingContact.countryCode || '',
          'billing_address_1': billingContact.addressLines[0] || '',
          'billing_address_2': billingContact.addressLines[1] || '',
          'billing_postcode': billingContact.postalCode || '',
          'billing_city': billingContact.locality || '',
          'billing_state': billingContact.administrativeArea || '',
          'billing_phone': billingContact.phoneNumber || '000000000000',
          'billing_email': shippingContact.emailAddress || '',
          'shipping_first_name': shippingContact.givenName || '',
          'shipping_last_name': shippingContact.familyName || '',
          'shipping_company': '',
          'shipping_country': shippingContact.countryCode || '',
          'shipping_address_1': shippingContact.addressLines[0] || '',
          'shipping_address_2': shippingContact.addressLines[1] || '',
          'shipping_postcode': shippingContact.postalCode || '',
          'shipping_city': shippingContact.locality || '',
          'shipping_state': shippingContact.administrativeArea || '',
          'shipping_phone': shippingContact.phoneNumber || '000000000000',
          'shipping_email': shippingContact.emailAddress || '',
          'order_comments': '',
          'payment_method': 'mollie_wc_gateway_applepay',
          '_wp_http_referer': '/?wc-ajax=update_order_review'
        },
        complete: function complete(jqXHR, textStatus) {},
        success: function success(authorizationResult, textStatus, jqXHR) {
          var result = authorizationResult.data;
          if (authorizationResult.success === true) {
            redirectionUrl = result['returnUrl'];
            session.completePayment(result['responseToApple']);
            window.location.href = redirectionUrl;
          } else {
            result.errors = (0,_applePayError_js__WEBPACK_IMPORTED_MODULE_0__.createAppleErrors)(result.errors);
            session.completePayment(result);
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
  };
  document.querySelector('#mollie_applepay_button').addEventListener('click', function (evt) {
    evt.preventDefault();
    applePaySession();
  });
})(window);
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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