/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./resources/js/applePayError.js":
/*!***************************************!*\
  !*** ./resources/js/applePayError.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createAppleErrors: () => (/* binding */ createAppleErrors)
/* harmony export */ });
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function createAppleErrors(errors) {
  var errorList = [];
  var _iterator = _createForOfIteratorHelper(errors),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var error = _step.value;
      var _error$contactField = error.contactField,
        contactField = _error$contactField === void 0 ? null : _error$contactField,
        _error$code = error.code,
        code = _error$code === void 0 ? null : _error$code,
        _error$message = error.message,
        message = _error$message === void 0 ? null : _error$message;
      var appleError = contactField ? new ApplePayError(code, contactField, message) : new ApplePayError(code);
      errorList.push(appleError);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return errorList;
}

/***/ }),

/***/ "./resources/js/applePayRequest.js":
/*!*****************************************!*\
  !*** ./resources/js/applePayRequest.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   request: () => (/* binding */ request)
/* harmony export */ });
var request = function request(countryCode, currencyCode, totalLabel, subtotal) {
  return {
    countryCode: countryCode,
    currencyCode: currencyCode,
    supportedNetworks: ['amex', 'maestro', 'masterCard', 'visa', 'vPay'],
    merchantCapabilities: ['supports3DS'],
    shippingType: 'shipping',
    requiredBillingContactFields: ['postalAddress', 'email'],
    requiredShippingContactFields: ['postalAddress', 'email'],
    total: {
      label: totalLabel,
      amount: subtotal,
      type: 'final'
    }
  };
};

/***/ }),

/***/ "./resources/js/blocks/ApplePayButtonComponent.js":
/*!********************************************************!*\
  !*** ./resources/js/blocks/ApplePayButtonComponent.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ApplePayButtonComponent: () => (/* binding */ ApplePayButtonComponent),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _applePayRequest__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../applePayRequest */ "./resources/js/applePayRequest.js");
/* harmony import */ var _applePayError__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../applePayError */ "./resources/js/applePayError.js");


var ApplePayButtonComponent = function ApplePayButtonComponent(_ref) {
  var _ref$buttonAttributes = _ref.buttonAttributes,
    buttonAttributes = _ref$buttonAttributes === void 0 ? {} : _ref$buttonAttributes;
  var mollieApplePayBlockDataCart = window.mollieApplePayBlockDataCart || window.mollieBlockData.mollieApplePayBlockDataCart;
  var nonce = document.getElementById("woocommerce-process-checkout-nonce").value;
  var updatedContactInfo = [];
  var redirectionUrl = '';
  var _mollieApplePayBlockD = mollieApplePayBlockDataCart.product,
    _mollieApplePayBlockD2 = _mollieApplePayBlockD.needShipping,
    needShipping = _mollieApplePayBlockD2 === void 0 ? true : _mollieApplePayBlockD2,
    subtotal = _mollieApplePayBlockD.subtotal,
    _mollieApplePayBlockD3 = mollieApplePayBlockDataCart.shop,
    countryCode = _mollieApplePayBlockD3.countryCode,
    _mollieApplePayBlockD4 = _mollieApplePayBlockD3.currencyCode,
    currencyCode = _mollieApplePayBlockD4 === void 0 ? 'EUR' : _mollieApplePayBlockD4,
    _mollieApplePayBlockD5 = _mollieApplePayBlockD3.totalLabel,
    totalLabel = _mollieApplePayBlockD5 === void 0 ? '' : _mollieApplePayBlockD5,
    ajaxUrl = mollieApplePayBlockDataCart.ajaxUrl;
  var style = {
    height: "".concat(buttonAttributes.height || 48, "px"),
    borderRadius: "".concat(buttonAttributes.borderRadius || 4, "px")
  };
  var findSelectedShippingMethod = function findSelectedShippingMethod(shippingRates) {
    var shippingRate = shippingRates.find(function (shippingMethod) {
      return shippingMethod.selected === true;
    });
    var appleFormattedRate = {
      amount: '',
      detail: '',
      label: shippingRate.name,
      identifier: shippingRate.rate_id,
      selected: shippingRate.selected
    };
    return shippingRate ? appleFormattedRate : '';
  };
  var applePaySession = function applePaySession() {
    var _store$getShippingRat;
    var session = new ApplePaySession(3, (0,_applePayRequest__WEBPACK_IMPORTED_MODULE_0__.request)(countryCode, currencyCode, totalLabel, subtotal));
    var store = wp.data.select('wc/store/cart');
    var shippingRates = (_store$getShippingRat = store.getShippingRates()) === null || _store$getShippingRat === void 0 || (_store$getShippingRat = _store$getShippingRat[0]) === null || _store$getShippingRat === void 0 ? void 0 : _store$getShippingRat.shipping_rates;
    var selectedShippingMethod = '';
    if (shippingRates && shippingRates.length > 0) {
      selectedShippingMethod = findSelectedShippingMethod(shippingRates, selectedShippingMethod);
    }
    session.onshippingmethodselected = function (event) {
      var _this = this;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_update_shipping_method',
          shippingMethod: event.shippingMethod,
          callerPage: 'cart',
          simplifiedContact: updatedContactInfo,
          'woocommerce-process-checkout-nonce': nonce
        },
        success: function success(applePayShippingMethodUpdate, textStatus, jqXHR) {
          var response = applePayShippingMethodUpdate.data;
          selectedShippingMethod = event.shippingMethod;
          if (applePayShippingMethodUpdate.success === false) {
            response.errors = (0,_applePayError__WEBPACK_IMPORTED_MODULE_1__.createAppleErrors)(response.errors);
          }
          _this.completeShippingMethodSelection(response);
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onshippingcontactselected = function (event) {
      var _this2 = this;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_update_shipping_contact',
          simplifiedContact: event.shippingContact,
          callerPage: 'cart',
          needShipping: needShipping,
          'woocommerce-process-checkout-nonce': nonce,
          shippingMethod: selectedShippingMethod
        },
        success: function success(applePayShippingContactUpdate, textStatus, jqXHR) {
          var response = applePayShippingContactUpdate.data;
          updatedContactInfo = event.shippingContact;
          if (applePayShippingContactUpdate.success === false) {
            response.errors = (0,_applePayError__WEBPACK_IMPORTED_MODULE_1__.createAppleErrors)(response.errors);
          }
          if (response.newShippingMethods) {
            selectedShippingMethod = response.newShippingMethods[0];
          }
          _this2.completeShippingContactSelection(response);
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onvalidatemerchant = function (applePayValidateMerchantEvent) {
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_validation',
          validationUrl: applePayValidateMerchantEvent.validationURL,
          'woocommerce-process-checkout-nonce': nonce
        },
        success: function success(merchantSession, textStatus, jqXHR) {
          if (merchantSession.success === true) {
            session.completeMerchantValidation(JSON.parse(merchantSession.data));
          } else {
            console.warn(merchantSession.data);
            session.abort();
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.onpaymentauthorized = function (ApplePayPayment) {
      var _ApplePayPayment$paym = ApplePayPayment.payment,
        billingContact = _ApplePayPayment$paym.billingContact,
        shippingContact = _ApplePayPayment$paym.shippingContact;
      jQuery.ajax({
        url: ajaxUrl,
        method: 'POST',
        data: {
          action: 'mollie_apple_pay_create_order_cart',
          shippingContact: ApplePayPayment.payment.shippingContact,
          billingContact: ApplePayPayment.payment.billingContact,
          token: ApplePayPayment.payment.token,
          shippingMethod: selectedShippingMethod,
          'mollie-payments-for-woocommerce_issuer_applepay': 'applepay',
          'woocommerce-process-checkout-nonce': nonce,
          'billing_first_name': billingContact.givenName || '',
          'billing_last_name': billingContact.familyName || '',
          'billing_company': '',
          'billing_country': billingContact.countryCode || '',
          'billing_address_1': billingContact.addressLines[0] || '',
          'billing_address_2': billingContact.addressLines[1] || '',
          'billing_postcode': billingContact.postalCode || '',
          'billing_city': billingContact.locality || '',
          'billing_state': billingContact.administrativeArea || '',
          'billing_phone': billingContact.phoneNumber || '000000000000',
          'billing_email': shippingContact.emailAddress || '',
          'shipping_first_name': shippingContact.givenName || '',
          'shipping_last_name': shippingContact.familyName || '',
          'shipping_company': '',
          'shipping_country': shippingContact.countryCode || '',
          'shipping_address_1': shippingContact.addressLines[0] || '',
          'shipping_address_2': shippingContact.addressLines[1] || '',
          'shipping_postcode': shippingContact.postalCode || '',
          'shipping_city': shippingContact.locality || '',
          'shipping_state': shippingContact.administrativeArea || '',
          'shipping_phone': shippingContact.phoneNumber || '000000000000',
          'shipping_email': shippingContact.emailAddress || '',
          'order_comments': '',
          'payment_method': 'mollie_wc_gateway_applepay',
          '_wp_http_referer': '/?wc-ajax=update_order_review'
        },
        success: function success(authorizationResult, textStatus, jqXHR) {
          var result = authorizationResult.data;
          if (authorizationResult.success === true) {
            redirectionUrl = result['returnUrl'];
            session.completePayment(result['responseToApple']);
            window.location.href = redirectionUrl;
          } else {
            result.errors = (0,_applePayError__WEBPACK_IMPORTED_MODULE_1__.createAppleErrors)(result.errors);
            session.completePayment(result);
          }
        },
        error: function error(jqXHR, textStatus, errorThrown) {
          console.warn(textStatus, errorThrown);
          session.abort();
        }
      });
    };
    session.begin();
  };
  return /*#__PURE__*/React.createElement("button", {
    id: "mollie_applepay_button",
    className: "apple-pay-button apple-pay-button-black",
    onClick: function onClick(event) {
      event.preventDefault();
      applePaySession();
    },
    style: style
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApplePayButtonComponent);

/***/ }),

/***/ "./resources/js/blocks/ApplePayButtonEditorComponent.js":
/*!**************************************************************!*\
  !*** ./resources/js/blocks/ApplePayButtonEditorComponent.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ApplePayButtonEditorComponent: () => (/* binding */ ApplePayButtonEditorComponent),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var ApplePayButtonEditorComponent = function ApplePayButtonEditorComponent(_ref) {
  var _ref$buttonAttributes = _ref.buttonAttributes,
    buttonAttributes = _ref$buttonAttributes === void 0 ? {} : _ref$buttonAttributes;
  var style = {
    height: "".concat(buttonAttributes.height || 48, "px"),
    borderRadius: "".concat(buttonAttributes.borderRadius || 4, "px")
  };
  return /*#__PURE__*/React.createElement("button", {
    id: "mollie_applepay_button",
    className: "apple-pay-button apple-pay-button-black",
    style: style
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApplePayButtonEditorComponent);

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!*********************************************!*\
  !*** ./resources/js/applepayButtonBlock.js ***!
  \*********************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _blocks_ApplePayButtonComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./blocks/ApplePayButtonComponent */ "./resources/js/blocks/ApplePayButtonComponent.js");
/* harmony import */ var _blocks_ApplePayButtonEditorComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./blocks/ApplePayButtonEditorComponent */ "./resources/js/blocks/ApplePayButtonEditorComponent.js");


(function (_ref) {
  var mollieApplePayBlockDataCart = _ref.mollieApplePayBlockDataCart;
  if (mollieApplePayBlockDataCart.length === 0) {
    return;
  }
  var _window = window,
    ApplePaySession = _window.ApplePaySession;
  if (!(ApplePaySession && ApplePaySession.canMakePayments())) {
    return null;
  }
  var registerExpressPaymentMethod = wc.wcBlocksRegistry.registerExpressPaymentMethod;
  registerExpressPaymentMethod({
    name: 'mollie_wc_gateway_applepay_express',
    content: /*#__PURE__*/React.createElement(_blocks_ApplePayButtonComponent__WEBPACK_IMPORTED_MODULE_0__.ApplePayButtonComponent, null),
    edit: /*#__PURE__*/React.createElement(_blocks_ApplePayButtonEditorComponent__WEBPACK_IMPORTED_MODULE_1__.ApplePayButtonEditorComponent, null),
    ariaLabel: 'Apple Pay',
    canMakePayment: function canMakePayment() {
      return true;
    },
    paymentMethodId: 'mollie_wc_gateway_applepay',
    supports: {
      features: ['products']
    }
  });
})(window);
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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