/******/ (() => { // webpackBootstrap
/*!******************************************!*\
  !*** ./resources/js/advancedSettings.js ***!
  \******************************************/
(function (_ref) {
  var _ = _ref._,
    jQuery = _ref.jQuery;
  function mollie_settings__insertTextAtCursor(target, text, dontIgnoreSelection) {
    if (target.setRangeText) {
      if (!dontIgnoreSelection) {
        // insert at end
        target.setRangeText(text, target.value.length, target.value.length, "end");
      } else {
        // replace selection
        target.setRangeText(text, target.selectionStart, target.selectionEnd, "end");
      }
    } else {
      target.focus();
      document.execCommand("insertText", false /*no UI*/, text);
    }
    target.focus();
  }
  jQuery(document).ready(function ($) {
    $(".mollie-settings-advanced-payment-desc-label").data("ignore-click", "false").on("mousedown", function (e) {
      var input = document.getElementById("mollie-payments-for-woocommerce_api_payment_description");
      if (document.activeElement && input === document.activeElement) {
        $(this).on("mouseup.molliesettings", function (e) {
          $(this).data("ignore-click", "true");
          $(this).off(".molliesettings");
          var tag = $(this).data("tag");
          var input = document.getElementById("mollie-payments-for-woocommerce_api_payment_description");
          mollie_settings__insertTextAtCursor(input, tag, true);
        });
      }
      var $this = $(this);
      $(window).on("mouseup.molliesettings drag.molliesettings blur.molliesettings", function (e) {
        $this.off(".molliesettings");
        $(window).off(".molliesettings");
      });
    }).on("click", function (e) {
      e.preventDefault();
      e.stopImmediatePropagation();
      if ($(this).data("ignore-click") === "false") {
        var tag = $(this).data("tag");
        var input = document.getElementById("mollie-payments-for-woocommerce_api_payment_description");
        mollie_settings__insertTextAtCursor(input, tag, false);
      } else {
        $(this).data("ignore-click", "false");
      }
    });
    registerManualCaptureFields();
  });
})(window);
function registerManualCaptureFields() {
  var onHoldSelect = jQuery('[name="mollie-payments-for-woocommerce_place_payment_onhold"]');
  if (onHoldSelect.length === 0) {
    return;
  }
  toggleManualCaptureFields(onHoldSelect);
  onHoldSelect.on('change', function () {
    toggleManualCaptureFields(onHoldSelect);
  });
}
function toggleManualCaptureFields(onHoldSelect) {
  var currentValue = onHoldSelect.find('option:selected');
  if (currentValue.length === 0) {
    return;
  }
  var captureStatusChangeField = jQuery('[name="mollie-payments-for-woocommerce_capture_or_void"]');
  if (captureStatusChangeField.length === 0) {
    return;
  }
  var captureStatusChangeFieldParent = captureStatusChangeField.closest('tr');
  if (captureStatusChangeFieldParent.length === 0) {
    return;
  }
  if (currentValue.val() === 'later_capture') {
    captureStatusChangeFieldParent.show();
  } else {
    captureStatusChangeFieldParent.hide();
  }
}
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWR2YW5jZWRTZXR0aW5ncy5taW4uanMiLCJtYXBwaW5ncyI6Ijs7OztBQUFBLENBQ0ksVUFBQUEsSUFBQSxFQUF1QjtFQUFBLElBQVpDLENBQUMsR0FBQUQsSUFBQSxDQUFEQyxDQUFDO0lBQUVDLE1BQU0sR0FBQUYsSUFBQSxDQUFORSxNQUFNO0VBRWhCLFNBQVNDLG1DQUFtQ0EsQ0FBQ0MsTUFBTSxFQUFFQyxJQUFJLEVBQUVDLG1CQUFtQixFQUFFO0lBQzVFLElBQUlGLE1BQU0sQ0FBQ0csWUFBWSxFQUFFO01BQ3JCLElBQUksQ0FBQ0QsbUJBQW1CLEVBQUU7UUFDdEI7UUFDQUYsTUFBTSxDQUFDRyxZQUFZLENBQUNGLElBQUksRUFBRUQsTUFBTSxDQUFDSSxLQUFLLENBQUNDLE1BQU0sRUFBRUwsTUFBTSxDQUFDSSxLQUFLLENBQUNDLE1BQU0sRUFBRSxLQUFLLENBQUM7TUFDOUUsQ0FBQyxNQUFNO1FBQ0g7UUFDQUwsTUFBTSxDQUFDRyxZQUFZLENBQUNGLElBQUksRUFBRUQsTUFBTSxDQUFDTSxjQUFjLEVBQUVOLE1BQU0sQ0FBQ08sWUFBWSxFQUFFLEtBQUssQ0FBQztNQUNoRjtJQUNKLENBQUMsTUFBTTtNQUNIUCxNQUFNLENBQUNRLEtBQUssQ0FBQyxDQUFDO01BQ2RDLFFBQVEsQ0FBQ0MsV0FBVyxDQUFDLFlBQVksRUFBRSxLQUFLLENBQUMsV0FBV1QsSUFBSSxDQUFDO0lBQzdEO0lBQ0FELE1BQU0sQ0FBQ1EsS0FBSyxDQUFDLENBQUM7RUFDbEI7RUFFQVYsTUFBTSxDQUFDVyxRQUFRLENBQUMsQ0FBQ0UsS0FBSyxDQUFDLFVBQVVDLENBQUMsRUFBRTtJQUNoQ0EsQ0FBQyxDQUFDLDhDQUE4QyxDQUFDLENBQzVDQyxJQUFJLENBQUMsY0FBYyxFQUFFLE9BQU8sQ0FBQyxDQUM3QkMsRUFBRSxDQUFDLFdBQVcsRUFBRSxVQUFVQyxDQUFDLEVBQUU7TUFDMUIsSUFBTUMsS0FBSyxHQUFHUCxRQUFRLENBQUNRLGNBQWMsQ0FBQyx5REFBeUQsQ0FBQztNQUNoRyxJQUFJUixRQUFRLENBQUNTLGFBQWEsSUFBSUYsS0FBSyxLQUFLUCxRQUFRLENBQUNTLGFBQWEsRUFBRTtRQUM1RE4sQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDRSxFQUFFLENBQUMsd0JBQXdCLEVBQUUsVUFBVUMsQ0FBQyxFQUFFO1VBQzlDSCxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUNDLElBQUksQ0FBQyxjQUFjLEVBQUUsTUFBTSxDQUFDO1VBQ3BDRCxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUNPLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQztVQUM5QixJQUFNQyxHQUFHLEdBQUdSLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQ0MsSUFBSSxDQUFDLEtBQUssQ0FBQztVQUMvQixJQUFNRyxLQUFLLEdBQUdQLFFBQVEsQ0FBQ1EsY0FBYyxDQUFDLHlEQUF5RCxDQUFDO1VBQ2hHbEIsbUNBQW1DLENBQUNpQixLQUFLLEVBQUVJLEdBQUcsRUFBRSxJQUFJLENBQUM7UUFDekQsQ0FBQyxDQUFDO01BQ047TUFDQSxJQUFJQyxLQUFLLEdBQUdULENBQUMsQ0FBQyxJQUFJLENBQUM7TUFDbkJBLENBQUMsQ0FBQ1UsTUFBTSxDQUFDLENBQUNSLEVBQUUsQ0FBQyxnRUFBZ0UsRUFBRSxVQUFVQyxDQUFDLEVBQUU7UUFDeEZNLEtBQUssQ0FBQ0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDO1FBQzVCUCxDQUFDLENBQUNVLE1BQU0sQ0FBQyxDQUFDSCxHQUFHLENBQUMsaUJBQWlCLENBQUM7TUFDcEMsQ0FBQyxDQUFDO0lBQ04sQ0FBQyxDQUFDLENBQ0RMLEVBQUUsQ0FBQyxPQUFPLEVBQUUsVUFBVUMsQ0FBQyxFQUFFO01BQ3RCQSxDQUFDLENBQUNRLGNBQWMsQ0FBQyxDQUFDO01BQ2xCUixDQUFDLENBQUNTLHdCQUF3QixDQUFDLENBQUM7TUFDNUIsSUFBSVosQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDQyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssT0FBTyxFQUFFO1FBQzFDLElBQU1PLEdBQUcsR0FBR1IsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDQyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQy9CLElBQU1HLEtBQUssR0FBR1AsUUFBUSxDQUFDUSxjQUFjLENBQUMseURBQXlELENBQUM7UUFDaEdsQixtQ0FBbUMsQ0FBQ2lCLEtBQUssRUFBRUksR0FBRyxFQUFFLEtBQUssQ0FBQztNQUMxRCxDQUFDLE1BQU07UUFDSFIsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDQyxJQUFJLENBQUMsY0FBYyxFQUFFLE9BQU8sQ0FBQztNQUN6QztJQUNKLENBQUMsQ0FBQztJQUVOWSwyQkFBMkIsQ0FBQyxDQUFDO0VBQ2pDLENBQUMsQ0FBQztBQUNOLENBQUMsRUFHREgsTUFDSixDQUFDO0FBRUQsU0FBU0csMkJBQTJCQSxDQUFBLEVBQUc7RUFDbkMsSUFBTUMsWUFBWSxHQUFHNUIsTUFBTSxDQUFDLCtEQUErRCxDQUFDO0VBQzVGLElBQUk0QixZQUFZLENBQUNyQixNQUFNLEtBQUssQ0FBQyxFQUFFO0lBQzNCO0VBQ0o7RUFDQXNCLHlCQUF5QixDQUFDRCxZQUFZLENBQUM7RUFDdkNBLFlBQVksQ0FBQ1osRUFBRSxDQUFDLFFBQVEsRUFBRSxZQUFVO0lBQ2hDYSx5QkFBeUIsQ0FBQ0QsWUFBWSxDQUFDO0VBQzNDLENBQUMsQ0FBQztBQUNOO0FBRUEsU0FBU0MseUJBQXlCQSxDQUFDRCxZQUFZLEVBQUU7RUFDN0MsSUFBTUUsWUFBWSxHQUFHRixZQUFZLENBQUNHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztFQUN6RCxJQUFJRCxZQUFZLENBQUN2QixNQUFNLEtBQUssQ0FBQyxFQUFFO0lBQzNCO0VBQ0o7RUFFQSxJQUFNeUIsd0JBQXdCLEdBQUdoQyxNQUFNLENBQUMsMERBQTBELENBQUM7RUFDbkcsSUFBSWdDLHdCQUF3QixDQUFDekIsTUFBTSxLQUFLLENBQUMsRUFBRTtJQUN2QztFQUNKO0VBRUEsSUFBTTBCLDhCQUE4QixHQUFHRCx3QkFBd0IsQ0FBQ0UsT0FBTyxDQUFDLElBQUksQ0FBQztFQUM3RSxJQUFJRCw4QkFBOEIsQ0FBQzFCLE1BQU0sS0FBSyxDQUFDLEVBQUU7SUFDN0M7RUFDSjtFQUVBLElBQUl1QixZQUFZLENBQUNLLEdBQUcsQ0FBQyxDQUFDLEtBQUssZUFBZSxFQUFFO0lBQ3hDRiw4QkFBOEIsQ0FBQ0csSUFBSSxDQUFDLENBQUM7RUFDekMsQ0FBQyxNQUFNO0lBQ0hILDhCQUE4QixDQUFDSSxJQUFJLENBQUMsQ0FBQztFQUN6QztBQUNKLEMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9tb2xsaWUtcGF5bWVudHMtZm9yLXdvb2NvbW1lcmNlLy4vcmVzb3VyY2VzL2pzL2FkdmFuY2VkU2V0dGluZ3MuanMiXSwic291cmNlc0NvbnRlbnQiOlsiKFxuICAgIGZ1bmN0aW9uICh7XywgalF1ZXJ5fSkge1xuXG4gICAgICAgIGZ1bmN0aW9uIG1vbGxpZV9zZXR0aW5nc19faW5zZXJ0VGV4dEF0Q3Vyc29yKHRhcmdldCwgdGV4dCwgZG9udElnbm9yZVNlbGVjdGlvbikge1xuICAgICAgICAgICAgaWYgKHRhcmdldC5zZXRSYW5nZVRleHQpIHtcbiAgICAgICAgICAgICAgICBpZiAoIWRvbnRJZ25vcmVTZWxlY3Rpb24pIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gaW5zZXJ0IGF0IGVuZFxuICAgICAgICAgICAgICAgICAgICB0YXJnZXQuc2V0UmFuZ2VUZXh0KHRleHQsIHRhcmdldC52YWx1ZS5sZW5ndGgsIHRhcmdldC52YWx1ZS5sZW5ndGgsIFwiZW5kXCIpO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIHJlcGxhY2Ugc2VsZWN0aW9uXG4gICAgICAgICAgICAgICAgICAgIHRhcmdldC5zZXRSYW5nZVRleHQodGV4dCwgdGFyZ2V0LnNlbGVjdGlvblN0YXJ0LCB0YXJnZXQuc2VsZWN0aW9uRW5kLCBcImVuZFwiKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIHRhcmdldC5mb2N1cygpO1xuICAgICAgICAgICAgICAgIGRvY3VtZW50LmV4ZWNDb21tYW5kKFwiaW5zZXJ0VGV4dFwiLCBmYWxzZSAvKm5vIFVJKi8sIHRleHQpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdGFyZ2V0LmZvY3VzKCk7XG4gICAgICAgIH1cblxuICAgICAgICBqUXVlcnkoZG9jdW1lbnQpLnJlYWR5KGZ1bmN0aW9uICgkKSB7XG4gICAgICAgICAgICAkKFwiLm1vbGxpZS1zZXR0aW5ncy1hZHZhbmNlZC1wYXltZW50LWRlc2MtbGFiZWxcIilcbiAgICAgICAgICAgICAgICAuZGF0YShcImlnbm9yZS1jbGlja1wiLCBcImZhbHNlXCIpXG4gICAgICAgICAgICAgICAgLm9uKFwibW91c2Vkb3duXCIsIGZ1bmN0aW9uIChlKSB7XG4gICAgICAgICAgICAgICAgICAgIGNvbnN0IGlucHV0ID0gZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoXCJtb2xsaWUtcGF5bWVudHMtZm9yLXdvb2NvbW1lcmNlX2FwaV9wYXltZW50X2Rlc2NyaXB0aW9uXCIpO1xuICAgICAgICAgICAgICAgICAgICBpZiAoZG9jdW1lbnQuYWN0aXZlRWxlbWVudCAmJiBpbnB1dCA9PT0gZG9jdW1lbnQuYWN0aXZlRWxlbWVudCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgJCh0aGlzKS5vbihcIm1vdXNldXAubW9sbGllc2V0dGluZ3NcIiwgZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAkKHRoaXMpLmRhdGEoXCJpZ25vcmUtY2xpY2tcIiwgXCJ0cnVlXCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICQodGhpcykub2ZmKFwiLm1vbGxpZXNldHRpbmdzXCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvbnN0IHRhZyA9ICQodGhpcykuZGF0YShcInRhZ1wiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb25zdCBpbnB1dCA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKFwibW9sbGllLXBheW1lbnRzLWZvci13b29jb21tZXJjZV9hcGlfcGF5bWVudF9kZXNjcmlwdGlvblwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBtb2xsaWVfc2V0dGluZ3NfX2luc2VydFRleHRBdEN1cnNvcihpbnB1dCwgdGFnLCB0cnVlKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIGxldCAkdGhpcyA9ICQodGhpcyk7XG4gICAgICAgICAgICAgICAgICAgICQod2luZG93KS5vbihcIm1vdXNldXAubW9sbGllc2V0dGluZ3MgZHJhZy5tb2xsaWVzZXR0aW5ncyBibHVyLm1vbGxpZXNldHRpbmdzXCIsIGZ1bmN0aW9uIChlKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAkdGhpcy5vZmYoXCIubW9sbGllc2V0dGluZ3NcIik7XG4gICAgICAgICAgICAgICAgICAgICAgICAkKHdpbmRvdykub2ZmKFwiLm1vbGxpZXNldHRpbmdzXCIpO1xuICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgIC5vbihcImNsaWNrXCIsIGZ1bmN0aW9uIChlKSB7XG4gICAgICAgICAgICAgICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgICAgICAgICAgICAgZS5zdG9wSW1tZWRpYXRlUHJvcGFnYXRpb24oKTtcbiAgICAgICAgICAgICAgICAgICAgaWYgKCQodGhpcykuZGF0YShcImlnbm9yZS1jbGlja1wiKSA9PT0gXCJmYWxzZVwiKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBjb25zdCB0YWcgPSAkKHRoaXMpLmRhdGEoXCJ0YWdcIik7XG4gICAgICAgICAgICAgICAgICAgICAgICBjb25zdCBpbnB1dCA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKFwibW9sbGllLXBheW1lbnRzLWZvci13b29jb21tZXJjZV9hcGlfcGF5bWVudF9kZXNjcmlwdGlvblwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIG1vbGxpZV9zZXR0aW5nc19faW5zZXJ0VGV4dEF0Q3Vyc29yKGlucHV0LCB0YWcsIGZhbHNlKTtcbiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICQodGhpcykuZGF0YShcImlnbm9yZS1jbGlja1wiLCBcImZhbHNlXCIpO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgIDtcbiAgICAgICAgICAgIHJlZ2lzdGVyTWFudWFsQ2FwdHVyZUZpZWxkcygpO1xuICAgICAgICB9KTtcbiAgICB9XG4pXG4oXG4gICAgd2luZG93XG4pXG5cbmZ1bmN0aW9uIHJlZ2lzdGVyTWFudWFsQ2FwdHVyZUZpZWxkcygpIHtcbiAgICBjb25zdCBvbkhvbGRTZWxlY3QgPSBqUXVlcnkoJ1tuYW1lPVwibW9sbGllLXBheW1lbnRzLWZvci13b29jb21tZXJjZV9wbGFjZV9wYXltZW50X29uaG9sZFwiXScpO1xuICAgIGlmIChvbkhvbGRTZWxlY3QubGVuZ3RoID09PSAwKSB7XG4gICAgICAgIHJldHVybjtcbiAgICB9XG4gICAgdG9nZ2xlTWFudWFsQ2FwdHVyZUZpZWxkcyhvbkhvbGRTZWxlY3QpO1xuICAgIG9uSG9sZFNlbGVjdC5vbignY2hhbmdlJywgZnVuY3Rpb24oKXtcbiAgICAgICAgdG9nZ2xlTWFudWFsQ2FwdHVyZUZpZWxkcyhvbkhvbGRTZWxlY3QpO1xuICAgIH0pXG59XG5cbmZ1bmN0aW9uIHRvZ2dsZU1hbnVhbENhcHR1cmVGaWVsZHMob25Ib2xkU2VsZWN0KSB7XG4gICAgY29uc3QgY3VycmVudFZhbHVlID0gb25Ib2xkU2VsZWN0LmZpbmQoJ29wdGlvbjpzZWxlY3RlZCcpO1xuICAgIGlmIChjdXJyZW50VmFsdWUubGVuZ3RoID09PSAwKSB7XG4gICAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBjb25zdCBjYXB0dXJlU3RhdHVzQ2hhbmdlRmllbGQgPSBqUXVlcnkoJ1tuYW1lPVwibW9sbGllLXBheW1lbnRzLWZvci13b29jb21tZXJjZV9jYXB0dXJlX29yX3ZvaWRcIl0nKTtcbiAgICBpZiAoY2FwdHVyZVN0YXR1c0NoYW5nZUZpZWxkLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgY2FwdHVyZVN0YXR1c0NoYW5nZUZpZWxkUGFyZW50ID0gY2FwdHVyZVN0YXR1c0NoYW5nZUZpZWxkLmNsb3Nlc3QoJ3RyJyk7XG4gICAgaWYgKGNhcHR1cmVTdGF0dXNDaGFuZ2VGaWVsZFBhcmVudC5sZW5ndGggPT09IDApIHtcbiAgICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGlmIChjdXJyZW50VmFsdWUudmFsKCkgPT09ICdsYXRlcl9jYXB0dXJlJykge1xuICAgICAgICBjYXB0dXJlU3RhdHVzQ2hhbmdlRmllbGRQYXJlbnQuc2hvdygpO1xuICAgIH0gZWxzZSB7XG4gICAgICAgIGNhcHR1cmVTdGF0dXNDaGFuZ2VGaWVsZFBhcmVudC5oaWRlKCk7XG4gICAgfVxufVxuIl0sIm5hbWVzIjpbIl9yZWYiLCJfIiwialF1ZXJ5IiwibW9sbGllX3NldHRpbmdzX19pbnNlcnRUZXh0QXRDdXJzb3IiLCJ0YXJnZXQiLCJ0ZXh0IiwiZG9udElnbm9yZVNlbGVjdGlvbiIsInNldFJhbmdlVGV4dCIsInZhbHVlIiwibGVuZ3RoIiwic2VsZWN0aW9uU3RhcnQiLCJzZWxlY3Rpb25FbmQiLCJmb2N1cyIsImRvY3VtZW50IiwiZXhlY0NvbW1hbmQiLCJyZWFkeSIsIiQiLCJkYXRhIiwib24iLCJlIiwiaW5wdXQiLCJnZXRFbGVtZW50QnlJZCIsImFjdGl2ZUVsZW1lbnQiLCJvZmYiLCJ0YWciLCIkdGhpcyIsIndpbmRvdyIsInByZXZlbnREZWZhdWx0Iiwic3RvcEltbWVkaWF0ZVByb3BhZ2F0aW9uIiwicmVnaXN0ZXJNYW51YWxDYXB0dXJlRmllbGRzIiwib25Ib2xkU2VsZWN0IiwidG9nZ2xlTWFudWFsQ2FwdHVyZUZpZWxkcyIsImN1cnJlbnRWYWx1ZSIsImZpbmQiLCJjYXB0dXJlU3RhdHVzQ2hhbmdlRmllbGQiLCJjYXB0dXJlU3RhdHVzQ2hhbmdlRmllbGRQYXJlbnQiLCJjbG9zZXN0IiwidmFsIiwic2hvdyIsImhpZGUiXSwic291cmNlUm9vdCI6IiJ9