<div class="support-menu">
    <div class="heading iawp-container">
        <div class="inner">
            <h1>Welcome to the Support Center</h1>
        </div>
    </div>
    <div class="knowledge-base iawp-container">
        <div class="inner">
            <div class="kb-inner">
                <h2>Search the Knowledge Base for an Answer</h2>
                <form id="search-form" class="search-container">
                    <input id="search-field" type="search" class="search-field" placeholder="Search the Knowledge Base" />
                    <span class="dashicons dashicons-search"></span>
                </form>
                <p class="tutorial-links">
                    <a href="https://independentwp.com/knowledgebase/common-questions/views-not-recording/" target="_blank" class="link-purple">Why Aren't My Views Showing Up?</a> <span>&#8226;</span> <a href="https://independentwp.com/knowledgebase/data/what-is-a-view/" target="_blank" class="link-purple">What is a View?</a> <span>&#8226;</span> <a href="https://independentwp.com/knowledgebase/dashboard/save-reports-revisit-later/" target="_blank" class="link-purple">How to Create & Save Custom Reports</a> 
                    <span>&#8226;</span> <a href="https://independentwp.com/knowledgebase/tracking/block-ip-addresses/" target="_blank" class="link-purple">How to Block IP Addresses</a> <span>&#8226;</span> <a href="https://independentwp.com/knowledgebase/your-data/give-users-permission-view-analytics/" target="_blank" class="link-purple">How to Share Access with Non-Admins</a>
                </p>
                <p class="button-container">
                    <a href="https://independentwp.com/knowledgebase/dashboard/getting-started/" target="_blank" class="iawp-button purple"><span class="dashicons dashicons-video-alt3"></span> Getting Started Video Tutorial</a>
                    <a href="https://independentwp.com/knowledgebase/" target="_blank" class="iawp-button ghost-purple">View all tutorials</a>
                </p>
            </div>
        </div>
    </div>
    <div class="external-resources iawp-container">
        <div class="inner">
            <div class="ai-assistant resource">
                <div class="icon-container">
                    <span class="dashicons dashicons-superhero"></span>
                    <a class="overlay-link" href="https://independentwp.com/ai-assistant/">AI Assistant</a>
                </div>
                <div class="text">
                    <h2>AI Assistant</h2>
                    <p>Our AI Assistant is trained on our knowledge base and can quickly answer most questions.</p>
                    <a class="link-purple" target="_blank" href="https://independentwp.com/ai-assistant/">Ask Question</a>
                </div>
                <a class="overlay-link" target="_blank" href="https://independentwp.com/ai-assistant/">AI Assistant</a>
            </div>
            <div class="contact resource">
                <div class="icon-container">
                    <span class="dashicons dashicons-email-alt"></span>
                    <a class="overlay-link" href="<?php echo admin_url('admin.php?page=independent-analytics-contact'); ?>">Contact Us</a>
                </div>
                <div class="text">
                    <h2>Contact Form</h2>
                    <p>Submit the contact form to get help, report a bug, or ask a pre-sale question.</p>
                    <?php $url = $white_labeled ? 'https://independentwp.com/contact/' : admin_url('admin.php?page=independent-analytics-contact'); ?>
                    <a class="link-purple" href="<?php echo esc_attr($url); ?>">Contact Us</a>
                </div>
                <a class="overlay-link" href="<?php echo esc_attr($url); ?>">Contact Us</a>
            </div>
            <div class="forum resource">
                <div class="icon-container">
                    <span class="dashicons dashicons-groups"></span>
                    <a class="overlay-link" target="_blank" href="https://wordpress.org/support/plugin/independent-analytics/">Browse Forum</a>
                </div>
                <div class="text">
                    <h2>Support Forum</h2>
                    <p>Find an answer on the support forum or post your own thread with a question.</p>
                    <a class="link-purple" target="_blank" href="https://wordpress.org/support/plugin/independent-analytics/">Browse Forum</a>
                </div>
                <a class="overlay-link" target="_blank" href="https://wordpress.org/support/plugin/independent-analytics/">Browse Forum</a>
            </div>
            <div class="contact resource">
                <div class="icon-container">
                    <span class="dashicons dashicons-lightbulb"></span>
                    <a class="overlay-link" target="_blank" href="https://feedback.independentwp.com/roadmap">Submit Request</a>
                </div>
                <div class="text">
                    <h2>Feature Requests</h2>
                    <p>Submit a feature request and upvote  requests submited by other users.</p>
                    <a class="link-purple" target="_blank" href="https://feedback.independentwp.com/roadmap">Submit Request</a>
                </div>
                <a class="overlay-link" target="_blank" href="https://feedback.independentwp.com/roadmap">Submit Request</a>
            </div>
            <div class="review resource">
                <div class="icon-container">
                    <span class="dashicons dashicons-star-filled"></span>
                    <a class="overlay-link" target="_blank" href="https://wordpress.org/support/plugin/independent-analytics/reviews/?filter=5#new-post">Leave a Review</a>
                </div>
                <div class="text">
                    <h2>Leave us a review</h2>
                    <p>Loving Independent Analytics? Post a public review so other WP users can find out about our plugin.</p>
                    <a class="link-purple" target="_blank" href="https://wordpress.org/support/plugin/independent-analytics/reviews/?filter=5#new-post">Leave a Review</a>
                </div>
                <a class="overlay-link" target="_blank" href="https://wordpress.org/support/plugin/independent-analytics/reviews/?filter=5#new-post">Leave a Review</a>
            </div>
            <div class="follow-us resource">
                <div class="icon-container">
                    <span class="dashicons dashicons-twitter"></span>
                </div>
                <div class="text">
                    <h2>Follow Us</h2>
                    <p>Follow us on any of our profiles to find out when new updates are available and what's changed.</p>
                    <div class="social-icons-list">
                        <a href="https://twitter.com/AnalyticsForWP" target="_blank"><img src="<?php echo esc_url(iawp_url_to('img/twitter.svg')) ?>"/></a>
                        <a href="https://www.facebook.com/people/Independent-Analytics/100086904035609/" target="_blank"><img src="<?php echo esc_url(iawp_url_to('img/facebook.svg')) ?>"/></a>    
                        <a href="https://www.youtube.com/@Independent_Analytics" target="_blank"><img src="<?php echo esc_url(iawp_url_to('img/youtube.svg')) ?>"/></a>
                        <a href="https://www.reddit.com/r/independentanalytics/" target="_blank"><img src="<?php echo esc_url(iawp_url_to('img/reddit.svg')) ?>"/></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo iawp_blade()->run('partials.email-course-ad'); ?>
</div>